-- Extended Properties [tx].[AcceleratedInstructionSubjectDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3084. AcceleratedInstructionSubject indicates the subject in which the student is eligible to receive accelerated instruction.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AcceleratedInstructionSubjectDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AcceleratedInstructionSubjectDescriptor', @level2type=N'COLUMN', @level2name=N'AcceleratedInstructionSubjectDescriptorId'
GO

-- Extended Properties [tx].[ActualFunctionDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Function is populated from Code Table C146A.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ActualFunctionDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ActualFunctionDescriptor', @level2type=N'COLUMN', @level2name=N'ActualFunctionDescriptorId'
GO

-- Extended Properties [tx].[ActualFundDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Fund is populated from Code Table C145A.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ActualFundDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ActualFundDescriptor', @level2type=N'COLUMN', @level2name=N'ActualFundDescriptorId'
GO

-- Extended Properties [tx].[ActualObjectDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Object is populated from Code Table C159A.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ActualObjectDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ActualObjectDescriptor', @level2type=N'COLUMN', @level2name=N'ActualObjectDescriptorId'
GO

-- Extended Properties [tx].[ActualProgramIntentDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ProgramIntent is populated from Code Table C147A.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ActualProgramIntentDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ActualProgramIntentDescriptor', @level2type=N'COLUMN', @level2name=N'ActualProgramIntentDescriptorId'
GO

-- Extended Properties [tx].[ADAEligibilityDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ADAEligibility is populated from Code Table C059.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ADAEligibilityDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ADAEligibilityDescriptor', @level2type=N'COLUMN', @level2name=N'ADAEligibilityDescriptorId'
GO

-- Extended Properties [tx].[AdultPreviousAttendanceDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1660. AdultPreviousAttendance indicates whether an adult student (age 18-25) who is currently enrolled in a high school equivalency program, dropout recovery school, or other adult education program (under TEC §29.259), has or has not attended school in the previous nine months prior to enrolling.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AdultPreviousAttendanceDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AdultPreviousAttendanceDescriptor', @level2type=N'COLUMN', @level2name=N'AdultPreviousAttendanceDescriptorId'
GO

-- Extended Properties [tx].[ApiOperationTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Represents the type of operation on the API, e.g. create, delete, update', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ApiOperationTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ApiOperationTypeDescriptor', @level2type=N'COLUMN', @level2name=N'ApiOperationTypeDescriptorId'
GO

-- Extended Properties [tx].[ApplicationTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ApplicationType is populated from Code Table C327.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ApplicationTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ApplicationTypeDescriptor', @level2type=N'COLUMN', @level2name=N'ApplicationTypeDescriptorId'
GO

-- Extended Properties [tx].[ARDInvitedRepresentativeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3118. ARDInvitedRepresentative indicates whether or not there is evidence that a representative of any participating agency was invited to the Admission, Review, and Dismissal (ARD) Committee meeting with the prior consent of the parent or student who has reached age of majority.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ARDInvitedRepresentativeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ARDInvitedRepresentativeDescriptor', @level2type=N'COLUMN', @level2name=N'ARDInvitedRepresentativeDescriptorId'
GO

-- Extended Properties [tx].[ArmedServicesVocAptBatteryDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ArmedServicesVocAptBattery is populated from code table C217.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ArmedServicesVocAptBatteryDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ArmedServicesVocAptBatteryDescriptor', @level2type=N'COLUMN', @level2name=N'ArmedServicesVocAptBatteryDescriptorId'
GO

-- Extended Properties [tx].[AsOfStatusLastDayEnrollmentDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3006. AsOfStatusLastDayEnrollment indicates the student''s status in the district on the last day of school or last date of enrollment in the current school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AsOfStatusLastDayEnrollmentDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AsOfStatusLastDayEnrollmentDescriptor', @level2type=N'COLUMN', @level2name=N'AsOfStatusLastDayEnrollmentDescriptorId'
GO

-- Extended Properties [tx].[AsOfStatusLastFridayOctoberDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3007. AsOfStatusLastFridayOctober indicates the student''s status in the local education agency on the last Friday in October in the current school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AsOfStatusLastFridayOctoberDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AsOfStatusLastFridayOctoberDescriptor', @level2type=N'COLUMN', @level2name=N'AsOfStatusLastFridayOctoberDescriptorId'
GO

-- Extended Properties [tx].[AssessmentExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AssessmentExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique number or alphanumeric code assigned to an assessment.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AssessmentExtension', @level2type=N'COLUMN', @level2name=N'AssessmentIdentifier'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Namespace for the assessment.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AssessmentExtension', @level2type=N'COLUMN', @level2name=N'Namespace'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1573, C306. ReportAssessmentType indicates the TEA collection for which the assessment should be reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AssessmentExtension', @level2type=N'COLUMN', @level2name=N'ReportAssessmentTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1127, C312. The title or name of the assessment.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AssessmentExtension', @level2type=N'COLUMN', @level2name=N'TitleOfAssessmentDescriptorId'
GO

-- Extended Properties [tx].[AssessmentResultsObtainedDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor AssessmentResultsObtained identifies the result of tools or assessments used to assess the student''s language acquisition. (DC163)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AssessmentResultsObtainedDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AssessmentResultsObtainedDescriptor', @level2type=N'COLUMN', @level2name=N'AssessmentResultsObtainedDescriptorId'
GO

-- Extended Properties [tx].[AssociateDegreeIndicatorDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Function is populated from Code Table C235.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AssociateDegreeIndicatorDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AssociateDegreeIndicatorDescriptor', @level2type=N'COLUMN', @level2name=N'AssociateDegreeIndicatorDescriptorId'
GO

-- Extended Properties [tx].[AuxiliaryRoleIdDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor AuxiliaryRoleId is populated from code table C213.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AuxiliaryRoleIdDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'AuxiliaryRoleIdDescriptor', @level2type=N'COLUMN', @level2name=N'AuxiliaryRoleIdDescriptorId'
GO

-- Extended Properties [tx].[BasicReportingPeriodAttendance] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This extended entity represents the recording of a student''s regular (basic) reporting period attendance.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BasicReportingPeriodAttendance'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0975. CalendarCode indicates a unique campus calendar of school days for a particular group of students on a campus. Students with the same instructional track have the same number of days taught in a particular reporting period at a campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BasicReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'CalendarCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0017, C050. GradeLevel indicates the current grade level of the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BasicReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'GradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0934, C130. ReportingPeriod indicates the period for which the attendance data are being reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BasicReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'ReportingPeriodDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BasicReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BasicReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0935. NumberDaysTaught indicates the number of days of instruction offered, as shown on the school calendar, during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BasicReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'NumberDaysTaught'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3090. NumberOfHoursInRPEP captures the number of hours during a particular reporting period a student participates in the Rural Pathway Excellence Partnership (R-PEP) program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BasicReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'NumberOfHoursInRPEP'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0036. TotalDaysAbsent indicates the total number of days the student was absent during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BasicReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'TotalDaysAbsent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0937. TotalEligibleDaysPresent indicates the total number of days the student was present and eligible for Foundation School Program funding during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BasicReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'TotalEligibleDaysPresent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0936. TotalIneligibleDaysPresent indicates the total number of days the student was present and ineligible for Foundation School Program funding during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BasicReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'TotalIneligibleDaysPresent'
GO

-- Extended Properties [tx].[BilingualESLFundingDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor BilingualESLFunding is based on code table C225.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BilingualESLFundingDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BilingualESLFundingDescriptor', @level2type=N'COLUMN', @level2name=N'BilingualESLFundingDescriptorId'
GO

-- Extended Properties [tx].[BilingualESLProgramReportingPeriodAttendance] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This extended entity represents the bilingual/ESL program attendance of a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BilingualESLProgramReportingPeriodAttendance'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1651, C225. BilingualESLFunding indicates the language program in which the student participates during the reporting period that generates funding under TEC 48.105.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'BilingualESLFundingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0975. CalendarCode indicates a unique campus calendar of school days for a particular group of students on a campus. Students with the same instructional track have the same number of days taught in a particular reporting period at a campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'CalendarCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0017, C050. GradeLevel indicates the current grade level of the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'GradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0934, C130. ReportingPeriod indicates the period for which the attendance data are being reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'ReportingPeriodDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0935. NumberDaysTaught indicates the number of days of instruction offered, as shown on the school calendar, during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'NumberDaysTaught'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0938. TotalEligBilingualESLDaysPresent indicates the total number of days the student was present and an eligible participant in the state-approved bilingual/ESL program during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'TotalEligBilingualESLDaysPresent'
GO

-- Extended Properties [tx].[BudgetExt] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The BudgetExtension Domain Entity represents the amount of monies allocated to be spent or received by an education organization as related to a specific account', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetExt'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3010. BeginDate indicates the month, day, and year for the specified data element becomes true of the student, staff, program, etc.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetExt', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0317, C146. Function identifies a general operational area and groups together related activities.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetExt', @level2type=N'COLUMN', @level2name=N'BudgetFunctionDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0316B, C145B. BudgetFund identifies the fund group and specific fund (when applicable) for the budget financial data.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetExt', @level2type=N'COLUMN', @level2name=N'BudgetFundDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0318, C159. Object identifies an account, a transaction, or a source of funds.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetExt', @level2type=N'COLUMN', @level2name=N'BudgetObjectDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0320, C147. ProgramIntent identifies the cost of instruction and other services that are directed toward a particular need of a specific set of students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetExt', @level2type=N'COLUMN', @level2name=N'BudgetProgramIntentDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetExt', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0974. FiscalYear is the last digit of the fiscal year, e.g., the fiscal year is 6 for the 2015-16 fiscal year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetExt', @level2type=N'COLUMN', @level2name=N'FiscalYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0319. Organization identifies the unique organizational unit within the district with which the account is associated.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetExt', @level2type=N'COLUMN', @level2name=N'Organization'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0321. BudgetAmount indicates the dollar value associated with budget financial account information.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetExt', @level2type=N'COLUMN', @level2name=N'BudgetAmount'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3020. EndDate indicates the month, day, and year for the specified data element becomes false of the student, staff, program, etc.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetExt', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[BudgetFunctionDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Function is populated from Code Table C146B.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetFunctionDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetFunctionDescriptor', @level2type=N'COLUMN', @level2name=N'BudgetFunctionDescriptorId'
GO

-- Extended Properties [tx].[BudgetFundDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Fund is populated from Code Table C145B.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetFundDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetFundDescriptor', @level2type=N'COLUMN', @level2name=N'BudgetFundDescriptorId'
GO

-- Extended Properties [tx].[BudgetObjectDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Object is populated from Code Table C159B.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetObjectDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetObjectDescriptor', @level2type=N'COLUMN', @level2name=N'BudgetObjectDescriptorId'
GO

-- Extended Properties [tx].[BudgetProgramIntentDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ProgramIntent is populated from Code Table C147B.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetProgramIntentDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'BudgetProgramIntentDescriptor', @level2type=N'COLUMN', @level2name=N'BudgetProgramIntentDescriptorId'
GO

-- Extended Properties [tx].[CalendarDateExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CalendarDateExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the calendar.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CalendarDateExtension', @level2type=N'COLUMN', @level2name=N'CalendarCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year of the calendar event.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CalendarDateExtension', @level2type=N'COLUMN', @level2name=N'Date'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CalendarDateExtension', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year associated with the calendar.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CalendarDateExtension', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1570, C204. CalendarWaiverEventType indicates the type of state approved waiver', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CalendarDateExtension', @level2type=N'COLUMN', @level2name=N'CalendarWaiverEventTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1599. SchoolDayInstructionalMinutes indicates the portion of the school day in which instruction takes place along with certain other exceptions and are considered a subset of operational minutes.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CalendarDateExtension', @level2type=N'COLUMN', @level2name=N'SchoolDayInstructionalMinutes'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1571. SchoolDayOperationalMinutes indicates the minutes that a campus operated on a particular school day for the purpose of student instruction.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CalendarDateExtension', @level2type=N'COLUMN', @level2name=N'SchoolDayOperationalMinutes'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1572. SchoolDayWaiverMinutes indicates the waiver minutes for the campus and calendar date.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CalendarDateExtension', @level2type=N'COLUMN', @level2name=N'SchoolDayWaiverMinutes'
GO

-- Extended Properties [tx].[CalendarWaiverEventTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor CalendarWaiverEventType is populated from Code Table C204.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CalendarWaiverEventTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CalendarWaiverEventTypeDescriptor', @level2type=N'COLUMN', @level2name=N'CalendarWaiverEventTypeDescriptorId'
GO

-- Extended Properties [tx].[CampusEnrollmentTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor CampusEnrollmentType is populated from code table C219.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CampusEnrollmentTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CampusEnrollmentTypeDescriptor', @level2type=N'COLUMN', @level2name=N'CampusEnrollmentTypeDescriptorId'
GO

-- Extended Properties [tx].[ChildCountFundingDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ChildCountFunding indicates under which federal program the student receiving special education and related services is counted. (C066)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ChildCountFundingDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ChildCountFundingDescriptor', @level2type=N'COLUMN', @level2name=N'ChildCountFundingDescriptorId'
GO

-- Extended Properties [tx].[CIStaffProgramIntentDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ProgramIntent is populated from Code Table C147C.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CIStaffProgramIntentDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CIStaffProgramIntentDescriptor', @level2type=N'COLUMN', @level2name=N'CIStaffProgramIntentDescriptorId'
GO

-- Extended Properties [tx].[ClassTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ClassType is populated from code table C179.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ClassTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ClassTypeDescriptor', @level2type=N'COLUMN', @level2name=N'ClassTypeDescriptorId'
GO

-- Extended Properties [tx].[ContractedInstructionalStaffFTEExt] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The ContractedInstructionalStaffFTEExtension Domain Entity represents financial information for contracted staff by Program Intent Code at the LEA/Campus level.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ContractedInstructionalStaffFTEExt'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0320, C147. ProgramIntent identifies the cost of instruction and other services that are directed toward a particular need of a specific set of students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ContractedInstructionalStaffFTEExt', @level2type=N'COLUMN', @level2name=N'CIStaffProgramIntentDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ContractedInstructionalStaffFTEExt', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ContractedInstructionalStaffFTEExt', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0980. TotalContractedInstrStaffFTE is a standard measurement of the portion of professional contracted instructional staff, expressed as a multiple of the standard work day, such as 7.7 FTEs.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ContractedInstructionalStaffFTEExt', @level2type=N'COLUMN', @level2name=N'TotalContractedInstrStaffFTE'
GO

-- Extended Properties [tx].[CourseSequenceDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor CourseSequence identifies the unique part(s) of a course when a course is taught during a single grading period or semester or across multiple grading periods or semesters.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseSequenceDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseSequenceDescriptor', @level2type=N'COLUMN', @level2name=N'CourseSequenceDescriptorId'
GO

-- Extended Properties [tx].[CourseTranscriptExt] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The CourseTranscript Entity represents the final record of a student''s performance in their courses at the end of a semester or school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0949, C136. CourseAttemptResult indicates the outcome for a course taken by a particular student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'CourseAttemptResultDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a course.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'CourseCourseCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'CourseCourseEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0948, C135. CourseSequence identifies the unique part(s) of a course when a course is taught during a single grading period or semester or across multiple grading periods or semesters.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'CourseSequenceDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The local code assigned by the School that identifies the course offering provided for the instruction of students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'LocalCourseCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The local identifier assigned to a section.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'SectionIdentifier'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the calendar for the academic session.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'SessionName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The term for the session during the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'TermDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1058. ATCIndicator indicates a high school course for which college credit may be awarded by a post-secondary institution under the conditions of a local articulation agreement or the statewide Advanced Technical Credit (ATC) program agreement.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'ATCIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1081. CollegeCreditHours indicate the number of college hours a student earned for the completion of a dual credit course.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'CollegeCreditHours'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3097, C355. DropoutRecoveryCourseCompletion indicates if the course completed by a student in a dropout recovery education program under TEC §29.081 was completed in person or remotely.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'DropoutRecoveryCourseCompletionDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1011. DualCreditIndicator indicates whether the student was eligible to receive both high school and college credit for a college course.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'DualCreditIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The value of credits or units of value awarded for the completion of a course.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'EarnedCredits'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3120. OnRampsDualEnrollmentIndicator indicates that the student has completed an OnRamps dual enrollment course.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'OnRampsDualEnrollmentIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3091. SummerSchoolIndicator indicates the course completed by a student was completed during the summer (between school years).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CourseTranscriptExt', @level2type=N'COLUMN', @level2name=N'SummerSchoolIndicator'
GO

-- Extended Properties [tx].[CrisisEventDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor CrisisEvent is populated from Code Table C178.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CrisisEventDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CrisisEventDescriptor', @level2type=N'COLUMN', @level2name=N'CrisisEventDescriptorId'
GO

-- Extended Properties [tx].[CTEProgramReportingPeriodAttendance] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This extended entity represents the CTE program attendance of a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramReportingPeriodAttendance'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0975. CalendarCode indicates a unique campus calendar of school days for a particular group of students on a campus. Students with the same instructional track have the same number of days taught in a particular reporting period at a campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'CalendarCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3013, C330. CTEServiceID refers to the approved career and technical education course that generates countact hours during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'CTEServiceIdDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0017, C050. GradeLevel indicates the current grade level of the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'GradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0934, C130. ReportingPeriod indicates the period for which the attendance data are being reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'ReportingPeriodDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0950. EligibleDaysPresentV1 indicates the total number of days the student was eligible and present and enrolled in an approved career and technical course that generated one contact hour during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'EligibleDaysPresentV1'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0951. EligibleDaysPresentV2 indicates the total number of days the student was eligible and present and enrolled in an approved career and technical course that generated two contact hours during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'EligibleDaysPresentV2'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0952. EligibleDaysPresentV3 indicates the total number of days the student was eligible and present and enrolled in an approved career and technical course that generated three contact hours during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'EligibleDaysPresentV3'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0935. NumberDaysTaught indicates the number of days of instruction offered, as shown on the school calendar, during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'NumberDaysTaught'
GO

-- Extended Properties [tx].[CTEProgramSvcDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3012. CTEProgramSvc defines the services provided by an education organization to populations of students associated with a CTE program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramSvcDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEProgramSvcDescriptor', @level2type=N'COLUMN', @level2name=N'CTEProgramSvcDescriptorId'
GO

-- Extended Properties [tx].[CTEServiceIdDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CTEServiceId refers to the approved career and technical education course that generates countact hours during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEServiceIdDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'CTEServiceIdDescriptor', @level2type=N'COLUMN', @level2name=N'CTEServiceIdDescriptorId'
GO

-- Extended Properties [tx].[DescriptorMappingHistory] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This entity is intended to log all changes to the descriptormapping table', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DescriptorMappingHistory'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date/time when the operation occurred', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DescriptorMappingHistory', @level2type=N'COLUMN', @level2name=N'DateOfOperation'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The namespace of the descriptor value to which the from descriptor value is mapped to.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DescriptorMappingHistory', @level2type=N'COLUMN', @level2name=N'MappedNamespace'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The descriptor value to which the from descriptor value is being mapped to.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DescriptorMappingHistory', @level2type=N'COLUMN', @level2name=N'MappedValue'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The namespace of the descriptor value that is being mapped to another value.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DescriptorMappingHistory', @level2type=N'COLUMN', @level2name=N'Namespace'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The descriptor value that is being mapped to another value.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DescriptorMappingHistory', @level2type=N'COLUMN', @level2name=N'Value'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User name of the account which created/modified the mapping', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DescriptorMappingHistory', @level2type=N'COLUMN', @level2name=N'AccountName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of operation performed on the descriptor', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DescriptorMappingHistory', @level2type=N'COLUMN', @level2name=N'ApiOperationTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The id of the resource in question', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DescriptorMappingHistory', @level2type=N'COLUMN', @level2name=N'DescriptorMappingId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DescriptorMappingHistory', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'School year in which the mapping was created/modified', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DescriptorMappingHistory', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO

-- Extended Properties [tx].[DifferenceReasonHoursAcceleratedInstructionDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3088. DifferenceReasonHoursAcceleratedInstruction indicates the reason the student did not complete the full number of assigned hours of accelerated instruction.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DifferenceReasonHoursAcceleratedInstructionDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DifferenceReasonHoursAcceleratedInstructionDescriptor', @level2type=N'COLUMN', @level2name=N'DifferenceReasonHoursAcceleratedInstructionDescriptorId'
GO

-- Extended Properties [tx].[DisciplineActionExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DisciplineActionExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier assigned by the education organization to the discipline action.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DisciplineActionExtension', @level2type=N'COLUMN', @level2name=N'DisciplineActionIdentifier'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date of the discipline action.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DisciplineActionExtension', @level2type=N'COLUMN', @level2name=N'DisciplineDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DisciplineActionExtension', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1008. ActualLengthOfDisciplinaryAssignment indicates the actual length in days of a student’s disciplinary assignment.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DisciplineActionExtension', @level2type=N'COLUMN', @level2name=N'ActualLengthOfDisciplinaryAssignment'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1656. InconsistentCodeOfConduct indicates whether an out-of-school suspension, disciplinary alternative education program placement, or expulsion action is inconsistent with a local education agency’s student code of conduct.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DisciplineActionExtension', @level2type=N'COLUMN', @level2name=N'InconsistentCodeOfConduct'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1725. NonMembershipDisciplineRestraintIndicator indicates the discipline incident or restraint event being reported is for a special education student enrolled, not in membership.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DisciplineActionExtension', @level2type=N'COLUMN', @level2name=N'NonMembershipDisciplineRestraintIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1007. OfficialLengthOfDisciplinaryAssignment indicates the official length in days of a student’s disciplinary assignment.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DisciplineActionExtension', @level2type=N'COLUMN', @level2name=N'OfficialLengthOfDisciplinaryAssignment'
GO

-- Extended Properties [tx].[DropoutRecoveryCourseCompletionDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3097. DropoutRecoveryCourseCompletion indicates if the course completed by a student in a dropout recovery education program under TEC §29.081 was completed in person or remotely.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DropoutRecoveryCourseCompletionDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DropoutRecoveryCourseCompletionDescriptor', @level2type=N'COLUMN', @level2name=N'DropoutRecoveryCourseCompletionDescriptorId'
GO

-- Extended Properties [tx].[DyslexiaRiskDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor DyslexiaRisk is populated from Code Table C222.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DyslexiaRiskDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DyslexiaRiskDescriptor', @level2type=N'COLUMN', @level2name=N'DyslexiaRiskDescriptorId'
GO

-- Extended Properties [tx].[DyslexiaScreeningExceptionReasonDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor DyslexiaScreeningExceptionReason is based on Code Table C231.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DyslexiaScreeningExceptionReasonDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DyslexiaScreeningExceptionReasonDescriptor', @level2type=N'COLUMN', @level2name=N'DyslexiaScreeningExceptionReasonDescriptorId'
GO

-- Extended Properties [tx].[DyslexiaServicesDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor DyslexiaServices is based on code table C224.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DyslexiaServicesDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'DyslexiaServicesDescriptor', @level2type=N'COLUMN', @level2name=N'DyslexiaServicesDescriptorId'
GO

-- Extended Properties [tx].[EarlyReadingIndicatorDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor EarlyReadingIndicator is populated from Code Table C195.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EarlyReadingIndicatorDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EarlyReadingIndicatorDescriptor', @level2type=N'COLUMN', @level2name=N'EarlyReadingIndicatorDescriptorId'
GO

-- Extended Properties [tx].[EconomicDisadvantageDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor EconomicDisadvantage is populated from Code Table C054.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EconomicDisadvantageDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EconomicDisadvantageDescriptor', @level2type=N'COLUMN', @level2name=N'EconomicDisadvantageDescriptorId'
GO

-- Extended Properties [tx].[ECSEServiceExitReasonDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3103. ECSEServiceExitReason indicaes the reason a student exited from a local education agency''s (LEA''s) early childhood special education (ECSE) Program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ECSEServiceExitReasonDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ECSEServiceExitReasonDescriptor', @level2type=N'COLUMN', @level2name=N'ECSEServiceExitReasonDescriptorId'
GO

-- Extended Properties [tx].[ECSEServiceLocationDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ECSEServiceLocation indicates whether or not the Early Childhood Special Education (ECSE) student received their early childhood special education services in a regular early childhood program, which is defined as a program that is designed for typically developing children ages three through five (not in kindergarten) and is not specifically or primarily designed for children with disabilities and includes (at the time of the placement decision) a majority of at least 50 percent of nondisabled children (i.e., children without an individualized education program (IEP)). (C184)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ECSEServiceLocationDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ECSEServiceLocationDescriptor', @level2type=N'COLUMN', @level2name=N'ECSEServiceLocationDescriptorId'
GO

-- Extended Properties [tx].[EligibilityDelayReasonDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor EligibilityDelayReason is based on Code Table C347', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EligibilityDelayReasonDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EligibilityDelayReasonDescriptor', @level2type=N'COLUMN', @level2name=N'EligibilityDelayReasonDescriptorId'
GO

-- Extended Properties [tx].[ELOActivityDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ELOActivity is populated from code table C229.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ELOActivityDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ELOActivityDescriptor', @level2type=N'COLUMN', @level2name=N'ELOActivityDescriptorId'
GO

-- Extended Properties [tx].[ELOTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ELOType is populated from code table C218.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ELOTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ELOTypeDescriptor', @level2type=N'COLUMN', @level2name=N'ELOTypeDescriptorId'
GO

-- Extended Properties [tx].[EmergentBilingualIndicatorDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0790. EmergentBilingualIndicator is an indication that the student has been identified as an emergent bilingual (EB) student by the Language Proficiency Assessment Committee (LPAC), or English proficient according to the criteria established in 19 TAC §89.1226.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EmergentBilingualIndicatorDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EmergentBilingualIndicatorDescriptor', @level2type=N'COLUMN', @level2name=N'EmergentBilingualIndicatorDescriptorId'
GO

-- Extended Properties [tx].[EndorsementCompletedDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3021. EndorsementCompleted indicates the student has successfully completed a Foundation High School Program to earn a STEM, Business and Industry, Public Services, Arts and Humanities, or Multi-Disciplinary Studies endorsement.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EndorsementCompletedDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EndorsementCompletedDescriptor', @level2type=N'COLUMN', @level2name=N'EndorsementCompletedDescriptorId'
GO

-- Extended Properties [tx].[EndorsementPursuingDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor EndorsementPursuing id=s populated from Code Table C333.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EndorsementPursuingDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EndorsementPursuingDescriptor', @level2type=N'COLUMN', @level2name=N'EndorsementPursuingDescriptorId'
GO

-- Extended Properties [tx].[EnrollmentTrackingVerificationDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor EnrollmentTrackingVerification is populated from Code Table C351.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EnrollmentTrackingVerificationDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EnrollmentTrackingVerificationDescriptor', @level2type=N'COLUMN', @level2name=N'EnrollmentTrackingVerificationDescriptorId'
GO

-- Extended Properties [tx].[EntrySkillsRatingDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor EntrySkillsRating is populated from Code Table C357.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EntrySkillsRatingDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EntrySkillsRatingDescriptor', @level2type=N'COLUMN', @level2name=N'EntrySkillsRatingDescriptorId'
GO

-- Extended Properties [tx].[EvaluationDelayReasonDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor EvaluationDelayReason is populated from code table C348.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EvaluationDelayReasonDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'EvaluationDelayReasonDescriptor', @level2type=N'COLUMN', @level2name=N'EvaluationDelayReasonDescriptorId'
GO

-- Extended Properties [tx].[ExitSkillsRatingDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ExitSkillsRating is populated from Code Table C359.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ExitSkillsRatingDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ExitSkillsRatingDescriptor', @level2type=N'COLUMN', @level2name=N'ExitSkillsRatingDescriptorId'
GO

-- Extended Properties [tx].[ExtendedSchoolYearServicesAttendance] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This extended entity represents the students who are served through the Extended School Year (ESY) Services Program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ExtendedSchoolYearServicesAttendance'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3031, C035. The FirstInstructionalSetting identifies the setting used in providing extended year services component of special education. The InstructionalSetting reported is the EducationalEnvironment in which the student was served during the regular school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ExtendedSchoolYearServicesAttendance', @level2type=N'COLUMN', @level2name=N'FirstInstructionalSettingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0017, C050. GradeLevel indicates the current grade level of the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ExtendedSchoolYearServicesAttendance', @level2type=N'COLUMN', @level2name=N'GradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ExtendedSchoolYearServicesAttendance', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ExtendedSchoolYearServicesAttendance', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3054, C035. The SecondInstructionalSetting identifies the setting used in providing extended year services component of special education. The InstructionalSetting reported is the EducationalEnvironment in which the student was served during the regular school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ExtendedSchoolYearServicesAttendance', @level2type=N'COLUMN', @level2name=N'SecondInstructionalSettingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1013. TotalESYContactHoursInFirstInstructionalSetting indicates the total contact hours in a special education setting provided to the student through the extended school year services component of special education. InstructionalSetting1 reported is the EducationalEnvironment in which the student was served during the regular school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ExtendedSchoolYearServicesAttendance', @level2type=N'COLUMN', @level2name=N'TotalESYContactHoursInFirstInstructionalSetting'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3096. TotalESYContactHoursInSecondInstructionalSetting indicates the total contact hours in a special education setting provided to the student through the extended school year services component of special education. InstructionalSetting1 reported is the EducationalEnvironment in which the student was served during the regular school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ExtendedSchoolYearServicesAttendance', @level2type=N'COLUMN', @level2name=N'TotalESYContactHoursInSecondInstructionalSetting'
GO

-- Extended Properties [tx].[FinancialAidApplicationDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1724. The FinancialAidApplication indicates the manner in which the student completed the graduation requirement of either completing a financial aid application (Free application for Federal Student Aid (FAFSA) or Texas Application for State Financial Aid (TASFA)) or submitting an exemption.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FinancialAidApplicationDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FinancialAidApplicationDescriptor', @level2type=N'COLUMN', @level2name=N'FinancialAidApplicationDescriptorId'
GO

-- Extended Properties [tx].[FlexAttendanceProgramDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor FlexAttendanceProgram is based on code table C177.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexAttendanceProgramDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexAttendanceProgramDescriptor', @level2type=N'COLUMN', @level2name=N'FlexAttendanceProgramDescriptorId'
GO

-- Extended Properties [tx].[FlexibleBilingualESLProgramReportingPeriodAttendance] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This extended entity represents the bilingual/ESL program attendance for the students who are served through a flexible attendance program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleBilingualESLProgramReportingPeriodAttendance'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1651, C225. BilingualESLFunding indicates the language program in which the student participates during the reporting period that generates funding under TEC 48.105.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleBilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'BilingualESLFundingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0975. CalendarCode indicates a unique campus calendar of school days for a particular group of students on a campus. Students with the same instructional track have the same number of days taught in a particular reporting period at a campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleBilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'CalendarCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1045, C177. FlexAttendanceProgram indicates the unique type of flexible attendance program to which the student’s flexible attendance is related.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleBilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexAttendanceProgramDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0017, C050. GradeLevel indicates the current grade level of the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleBilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'GradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0934, C130. ReportingPeriod indicates the period for which the attendance data are being reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleBilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'ReportingPeriodDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleBilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleBilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1050. FlexAttendExcessMinutesInInstrSetting indicates the total number of minutes the student was present in a designated instructional setting above the allowable 360-minute daily limit of combined career and technical education and special education and related services during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleBilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexTotalEligBilingualESLDaysPresent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0935. NumberDaysTaught indicates the number of days of instruction offered, as shown on the school calendar, during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleBilingualESLProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'NumberDaysTaught'
GO

-- Extended Properties [tx].[FlexibleCTEProgramReportingPeriodAttendance] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This extended entity represents the CTE program attendance for students who are served through a flexible attendance program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleCTEProgramReportingPeriodAttendance'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0975. CalendarCode indicates a unique campus calendar of school days for a particular group of students on a campus. Students with the same instructional track have the same number of days taught in a particular reporting period at a campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleCTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'CalendarCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1045, C177. FlexAttendanceProgram indicates the unique type of flexible attendance program to which the student’s flexible attendance is related.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleCTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexAttendanceProgramDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0017, C050. GradeLevel indicates the current grade level of the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleCTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'GradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0934, C130. ReportingPeriod indicates the period for which the attendance data are being reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleCTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'ReportingPeriodDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleCTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleCTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1053. FlexAttendTotalCareerTechMinutesPresent indicates the total number of minutes the student was present in an approved career and technical education course(s) that the student was eligible for and enrolled in during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleCTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexAttendTotalCareerTechMinutesPresent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0935. NumberDaysTaught indicates the number of days of instruction offered, as shown on the school calendar, during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleCTEProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'NumberDaysTaught'
GO

-- Extended Properties [tx].[FlexibleRegularProgramReportingPeriodAttendance] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This extended entity represents the attendance for students who are served through a flexible attendance program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0975. CalendarCode indicates a unique campus calendar of school days for a particular group of students on a campus. Students with the same instructional track have the same number of days taught in a particular reporting period at a campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'CalendarCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1045, C177. FlexAttendanceProgram indicates the unique type of flexible attendance program to which the student’s flexible attendance is related.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexAttendanceProgramDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0017, C050. GradeLevel indicates the current grade level of the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'GradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0934, C130. ReportingPeriod indicates the period for which the attendance data are being reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'ReportingPeriodDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1046. FlexAttendTotalEligibleMinutesPresent indicates the total number of minutes the student was present and eligible for Foundation School Program funding during a particular reporting period. Eligiblity for this program is determined by September 1 age and grade level.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexAttendTotalEligibleMinutesPresent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1047. FlexAttendTotalIneligibleMinutesPresent indicates the total number of minutes the student was present and ineligible for Foundation School Program funding during a particular reporting period. Ineligiblity for this program is determined by September 1 age and grade level.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexAttendTotalIneligibleMinutesPresent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1048. FlexTotalEligPregRelSvcsDaysPresent indicates the total number of school days a female student was eligible for Compensatory Education Home Instruction (CEHI) services and/or pregnancy related services during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexTotalEligPregRelSvcsDaysPresent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1653. FlexTotalEligResidentialFacilityDaysPresent indicates the total number of days the student was present and eligible for LEA services while living in a Residential Facility in a flexible attendance program during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexTotalEligResidentialFacilityDaysPresent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1049. FlexTotalEligSpEdMainstreamDaysPresent indicates the total number of school days a student with a special education individualized education program (IEP) that provided for the mainstream instructional arrangement/setting was eligible for that instructional arrangement/setting during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexTotalEligSpEdMainstreamDaysPresent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0935. NumberDaysTaught indicates the number of days of instruction offered, as shown on the school calendar, during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleRegularProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'NumberDaysTaught'
GO

-- Extended Properties [tx].[FlexibleSpecialEducationProgramReportingPeriodAttendance] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This extended entity represents the special education program attendance for students who are served through a flexible attendance program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleSpecialEducationProgramReportingPeriodAttendance'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0975. CalendarCode indicates a unique campus calendar of school days for a particular group of students on a campus. Students with the same instructional track have the same number of days taught in a particular reporting period at a campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleSpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'CalendarCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1045, C177. FlexAttendanceProgram indicates the unique type of flexible attendance program to which the student’s flexible attendance is related.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleSpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexAttendanceProgramDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0017, C050. GradeLevel indicates the current grade level of the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleSpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'GradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0173, C035. InstructionalSetting identifies the setting used in providing instruction to students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleSpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'InstructionalSettingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0934, C130. ReportingPeriod indicates the period for which the attendance data are being reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleSpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'ReportingPeriodDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleSpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleSpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1051. FlexAttendExcessMinutesInInstrSetting indicates the total number of minutes the student was present in a designated instructional setting above the allowable 360-minute daily limit of combined career and technical education and special education and related services during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleSpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexAttendDaysEligibleInInstrSetting'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1052. NumberDaysTaught indicates the number of days of instruction offered, as shown on the school calendar, during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleSpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'FlexAttendExcessMinutesInInstrSetting'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0935. NumberDaysTaught indicates the number of days of instruction offered, as shown on the school calendar, during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FlexibleSpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'NumberDaysTaught'
GO

-- Extended Properties [tx].[FosterCareTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor FosterCareType is populated from Code Table C196.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FosterCareTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FosterCareTypeDescriptor', @level2type=N'COLUMN', @level2name=N'FosterCareTypeDescriptorId'
GO

-- Extended Properties [tx].[FrequencyOfServicesDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor FrequencyOfServices identifies the frequency with which a student receives services. (C315)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FrequencyOfServicesDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FrequencyOfServicesDescriptor', @level2type=N'COLUMN', @level2name=N'FrequencyOfServicesDescriptorId'
GO

-- Extended Properties [tx].[FullTimeHybridVirtualProgramParticipationDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3131. FullTimeHybridVirtualProgramParticipation indicates the type (hybrid or virtual) of program participation for a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FullTimeHybridVirtualProgramParticipationDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'FullTimeHybridVirtualProgramParticipationDescriptor', @level2type=N'COLUMN', @level2name=N'FullTimeHybridVirtualProgramParticipationDescriptorId'
GO

-- Extended Properties [tx].[GenerationCodeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor GenerationCode is based on Code Table C012', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'GenerationCodeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'GenerationCodeDescriptor', @level2type=N'COLUMN', @level2name=N'GenerationCodeDescriptorId'
GO

-- Extended Properties [tx].[GiftedTalentedProgramDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor GiftedTalentedProgram is populated from code table C223', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'GiftedTalentedProgramDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'GiftedTalentedProgramDescriptor', @level2type=N'COLUMN', @level2name=N'GiftedTalentedProgramDescriptorId'
GO

-- Extended Properties [tx].[HearingAmplificationAccessDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor HearingAmplificationAccess identifies whether the student has access to the hearing amplification device for the full-day or partial day for each HEARING-AMPLIFICATION-TYPE reported. (C318)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'HearingAmplificationAccessDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'HearingAmplificationAccessDescriptor', @level2type=N'COLUMN', @level2name=N'HearingAmplificationAccessDescriptorId'
GO

-- Extended Properties [tx].[HearingAmplificationDailyUseDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor HearingAmplificationDailyUse identifies the average amount of time the hearing amplification device is used in a day based on the HEARING-AMPLIFICATION-ACCESS reported. (C319)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'HearingAmplificationDailyUseDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'HearingAmplificationDailyUseDescriptor', @level2type=N'COLUMN', @level2name=N'HearingAmplificationDailyUseDescriptorId'
GO

-- Extended Properties [tx].[HearingAmplificationTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor HearingAmplificationType identifies the type of hearing amplification device used by the student. (C317)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'HearingAmplificationTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'HearingAmplificationTypeDescriptor', @level2type=N'COLUMN', @level2name=N'HearingAmplificationTypeDescriptorId'
GO

-- Extended Properties [tx].[HomelessStatusDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1082. HomelessStatus as defined by 42 U.S.C. Section Part B §11434(a), definitions the term “homeless children and youths” —
(A) means individuals who lack a fixed, regular, and adequate nighttime residence [within the meaning of section 11302(a)(1)]; and
(B) the term includes —
(i) children and youths who are sharing the housing of other persons due to loss of housing, economic hardship, or a similar reason; are living in motels, hotels, trailer parks, or camping grounds due to the lack of alternative adequate accommodations; are living in emergency or transitional shelters
(ii) children and youths who have a primary nighttime residence that is a public or private place not designed for or ordinarily used as a regular sleeping accommodation for human beings [within the meaning of section 11302(a)(2)(C)];
(iii) children and youths who are living in cars, parks, public spaces, abandoned buildings, substandard housing, bus or train stations, or similar settings; and
(iv) migratory children (as such term is defined in section 6399 of title 20) who qualify as homeless for the purposes of this subtitle because the children are living in circumstances described in clauses (i) through (iii).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'HomelessStatusDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'HomelessStatusDescriptor', @level2type=N'COLUMN', @level2name=N'HomelessStatusDescriptorId'
GO

-- Extended Properties [tx].[HoursSpentReceivingServicesDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor HoursSpentReceivingServices identifies the amount of time in which the student receives services. (C316)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'HoursSpentReceivingServicesDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'HoursSpentReceivingServicesDescriptor', @level2type=N'COLUMN', @level2name=N'HoursSpentReceivingServicesDescriptorId'
GO

-- Extended Properties [tx].[IBCVendorDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor IBCVendorCode identifies the organization or company that offered the service. (C226)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'IBCVendorDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'IBCVendorDescriptor', @level2type=N'COLUMN', @level2name=N'IBCVendorDescriptorId'
GO

-- Extended Properties [tx].[InstructionalSettingDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor InstructionalSetting is based on code table C035.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'InstructionalSettingDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'InstructionalSettingDescriptor', @level2type=N'COLUMN', @level2name=N'InstructionalSettingDescriptorId'
GO

-- Extended Properties [tx].[LangAcqServicesProvidedDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor LangAcqServicesProvided indicates the specific language acquisition services provided to the student. (C314)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LangAcqServicesProvidedDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LangAcqServicesProvidedDescriptor', @level2type=N'COLUMN', @level2name=N'LangAcqServicesProvidedDescriptorId'
GO

-- Extended Properties [tx].[LangInstruProgramSvcDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3034. The LangInstruProgramSvc defines the services provided by an education organization to populations of students associated with a language instruction program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LangInstruProgramSvcDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LangInstruProgramSvcDescriptor', @level2type=N'COLUMN', @level2name=N'LangInstruProgramSvcDescriptorId'
GO

-- Extended Properties [tx].[LocalEducationAgencyExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a local education agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension', @level2type=N'COLUMN', @level2name=N'LocalEducationAgencyId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1625, C217. ArmedServicesVocAptBattery indicates whether a school district or open-enrollment charter school provides students in grades 10 through 12 an opportunity to take the Armed Services Vocational Aptitude Battery (ASVAB) test or a comparable substitute.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension', @level2type=N'COLUMN', @level2name=N'ArmedServicesVocAptBatteryDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3127. EarlyChildhoodTransitionReporting indicates a local educational agency does not have any students who meet the criteria for reporting SPP Indicator 12 Early Childhood Transition.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension', @level2type=N'COLUMN', @level2name=N'EarlyChildhoodTransitionReporting'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1583. FamilyEngagementPlanLink indicates the internet website address that connects directly to the Local Education Agency''s high-quality prekindergarten Family Engagement Plan document.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension', @level2type=N'COLUMN', @level2name=N'FamilyEngagementPlanLink'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3132. LEAGrievanceLink indicates the internet website address that connects directly to the Local Education Agency''s grievance policy.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension', @level2type=N'COLUMN', @level2name=N'LEAGrievanceLink'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1626, C216. PKProgramEvaluationType indicates the type of program evaluation tool LEAs use to report the progress of students participating in a High-Quality prekindergarten program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension', @level2type=N'COLUMN', @level2name=N'PKProgramEvaluationTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3098. PreschoolOutcomesReporting indicates a local education agency does not have any eligible students in an early childhood special education (ECSE) program that meet the criteria for reporting SPP Indicator 7 Preschool Outcomes.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension', @level2type=N'COLUMN', @level2name=N'PreschoolOutcomesReporting'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3128. SecondaryTransitionReporting indicates a local educational agency does not have any students who meet the criteria for reporting SPP Indicator 13 Secondary Transition.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension', @level2type=N'COLUMN', @level2name=N'SecondaryTransitionReporting'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3126. TimelyInitialEvaluationReporting indicates a local educational agency does not have any students who meet the criteria for reporting SPP Indicator 11 Timely Initial Evaluation (Child Find).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension', @level2type=N'COLUMN', @level2name=N'TimelyInitialEvaluationReporting'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1557. TotalCostSchoolBoardRequests indicates the cost to the district with fulfilling requests submitted outside of a school board meeting by a member of the district''s board of trustees (school board) for information, documents, and records as specified in TEC SECTION 11.1512.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension', @level2type=N'COLUMN', @level2name=N'TotalCostSchoolBoardRequests'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1556. TotalNumSchoolBoardRequests indicates the total number of requests submitted outside of a school board meeting by a member of the district''s board of trustees (school board) for information, documents, and records as specified in TEC SECTION 11.1512.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyExtension', @level2type=N'COLUMN', @level2name=N'TotalNumSchoolBoardRequests'
GO

-- Extended Properties [tx].[LocalEducationAgencyGiftedTalentedProgram] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1645, C223. GiftedTalentedProgram indicates a gifted and talented program the LEA has established that is consistent with the state plan developed under TEC 29.123.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyGiftedTalentedProgram'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a local education agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyGiftedTalentedProgram', @level2type=N'COLUMN', @level2name=N'LocalEducationAgencyId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1645, C223. GiftedTalentedProgram indicates a gifted and talented program the LEA has established that is consistent with the state plan developed under TEC 29.123.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyGiftedTalentedProgram', @level2type=N'COLUMN', @level2name=N'GiftedTalentedProgramDescriptorId'
GO

-- Extended Properties [tx].[LocalEducationAgencyProgramOfStudy] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1643, C220. ProgramOfStudy indicates a program of study the LEA offers. A program of study is a comprehensive, structured approach for delivering academic and career and technical education to prepare a student for postsecondary education and career success.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyProgramOfStudy'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a local education agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyProgramOfStudy', @level2type=N'COLUMN', @level2name=N'LocalEducationAgencyId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1643, C220. ProgramOfStudy indicates a program of study the LEA offers. A program of study is a comprehensive, structured approach for delivering academic and career and technical education to prepare a student for postsecondary education and career success.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'LocalEducationAgencyProgramOfStudy', @level2type=N'COLUMN', @level2name=N'ProgramOfStudyDescriptorId'
GO

-- Extended Properties [tx].[MilitaryConnectedStudentDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor MilitaryConnectedStudent is populated from Code Table C197.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'MilitaryConnectedStudentDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'MilitaryConnectedStudentDescriptor', @level2type=N'COLUMN', @level2name=N'MilitaryConnectedStudentDescriptorId'
GO

-- Extended Properties [tx].[NonCampusBasedInstructionDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor NonCampusBasedInstruction is populated by Code Table C182.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'NonCampusBasedInstructionDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'NonCampusBasedInstructionDescriptor', @level2type=N'COLUMN', @level2name=N'NonCampusBasedInstructionDescriptorId'
GO

-- Extended Properties [tx].[NonEnrolledStudentUILActivityDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Function is populated from Code Table C234.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'NonEnrolledStudentUILActivityDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'NonEnrolledStudentUILActivityDescriptor', @level2type=N'COLUMN', @level2name=N'NonEnrolledStudentUILActivityDescriptorId'
GO

-- Extended Properties [tx].[NSLPTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor NSLPType is populated from code table C212.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'NSLPTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'NSLPTypeDescriptor', @level2type=N'COLUMN', @level2name=N'NSLPTypeDescriptorId'
GO

-- Extended Properties [tx].[ParentalPermissionDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ParentalPermission indicates whether the student''s parent or legal guardian has approved placement of the student in the required bilingual or English as a Second Language (ESL) program or if the parent of a non-EB student has requested placement in a program. (See 19 TAC §89.1240.) (C093)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ParentalPermissionDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ParentalPermissionDescriptor', @level2type=N'COLUMN', @level2name=N'ParentalPermissionDescriptorId'
GO

-- Extended Properties [tx].[ParentExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ParentExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a parent.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ParentExtension', @level2type=N'COLUMN', @level2name=N'ParentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0706, C012. GenerationCode identifies the generation suffix, if any, which the person attaches to his name.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ParentExtension', @level2type=N'COLUMN', @level2name=N'GenerationCodeDescriptorId'
GO

-- Extended Properties [tx].[PayrollActivityDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PayrollActivity is populated from Code Table C018.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollActivityDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollActivityDescriptor', @level2type=N'COLUMN', @level2name=N'PayrollActivityDescriptorId'
GO

-- Extended Properties [tx].[PayrollExt] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The PayrollExtension Domain Entity represents the financial transactions for employee compensation.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3010. BeginDate is the first day a staff is scheduled to be paid a dollar value for a given PayrollActivity per year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0974. FiscalYear is the last digit of the fiscal year, e.g., the fiscal year is 4 for the 1993-94 fiscal year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'FiscalYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0319. Organization identifies the unique organizational unit within the district with which the account is associated.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'Organization'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0424, C018. PayrollActivity indicates the types of duty for which a staff member receives salary, salary supplements, or bonuses.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'PayrollActivityDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0317, C146. Function identifies a general operational area and groups together related activities.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'PayrollFunctionDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0316P, C145P. PayrollFund identifies the fund group and specific fund (when applicable) for the staff payroll financial data.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'PayrollFundDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0318, C159. Object identifies an account, a transaction, or a source of funds.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'PayrollObjectDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0320, C147. ProgramIntent identifies the cost of instruction and other services that are directed toward a particular need of a specific set of students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'PayrollProgramIntentDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'StaffUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3020.  is the first day after the last day a staff was paid the PayrollAmount.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0425. PayrollAmount indicates the dollar value that is paid to a staff member for a given payroll activity per year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollExt', @level2type=N'COLUMN', @level2name=N'PayrollAmount'
GO

-- Extended Properties [tx].[PayrollFunctionDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Function is populated from Code Table C146P.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollFunctionDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollFunctionDescriptor', @level2type=N'COLUMN', @level2name=N'PayrollFunctionDescriptorId'
GO

-- Extended Properties [tx].[PayrollFundDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Fund is populated from Code Table C145P.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollFundDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollFundDescriptor', @level2type=N'COLUMN', @level2name=N'PayrollFundDescriptorId'
GO

-- Extended Properties [tx].[PayrollObjectDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Object is populated from Code Table C159P.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollObjectDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollObjectDescriptor', @level2type=N'COLUMN', @level2name=N'PayrollObjectDescriptorId'
GO

-- Extended Properties [tx].[PayrollProgramIntentDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ProgramIntent is populated from Code Table C147P.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollProgramIntentDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PayrollProgramIntentDescriptor', @level2type=N'COLUMN', @level2name=N'PayrollProgramIntentDescriptorId'
GO

-- Extended Properties [tx].[PKCurriculaDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PKCurricula indicates curricula used in the district’s prekindergarten program section TEC 29.1532(c)(6). (C206)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKCurriculaDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKCurriculaDescriptor', @level2type=N'COLUMN', @level2name=N'PKCurriculaDescriptorId'
GO

-- Extended Properties [tx].[PKFundingSourceDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PKFundingSource is populated by Code Table C186.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKFundingSourceDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKFundingSourceDescriptor', @level2type=N'COLUMN', @level2name=N'PKFundingSourceDescriptorId'
GO

-- Extended Properties [tx].[PKProgramEvaluationTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PKProgramEvaluationType indicates for each High-Quality PK course/section, the type of program evaluation tool that is used. C216', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKProgramEvaluationTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKProgramEvaluationTypeDescriptor', @level2type=N'COLUMN', @level2name=N'PKProgramEvaluationTypeDescriptorId'
GO

-- Extended Properties [tx].[PKProgramTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PKProgramType is populated by Code Table C185.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKProgramTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKProgramTypeDescriptor', @level2type=N'COLUMN', @level2name=N'PKProgramTypeDescriptorId'
GO

-- Extended Properties [tx].[PKSchoolTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PKSchoolType is populated from Code Table C310.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKSchoolTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKSchoolTypeDescriptor', @level2type=N'COLUMN', @level2name=N'PKSchoolTypeDescriptorId'
GO

-- Extended Properties [tx].[PKStudentInstructionDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PKStudentInstruction C311.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKStudentInstructionDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKStudentInstructionDescriptor', @level2type=N'COLUMN', @level2name=N'PKStudentInstructionDescriptorId'
GO

-- Extended Properties [tx].[PKTeacherRequirementDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PKTeacherRequirement is populated from code table C207.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKTeacherRequirementDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PKTeacherRequirementDescriptor', @level2type=N'COLUMN', @level2name=N'PKTeacherRequirementDescriptorId'
GO

-- Extended Properties [tx].[PostSecondaryCertificationLicensureDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PostSecondaryCertificationLicensure indicates a nationally or internationally recognized business or industry certification or license earned by a student. (C214)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PostSecondaryCertificationLicensureDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PostSecondaryCertificationLicensureDescriptor', @level2type=N'COLUMN', @level2name=N'PostSecondaryCertificationLicensureDescriptorId'
GO

-- Extended Properties [tx].[PostSecondaryCertLicensureResultDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PostSecondaryCertLicensureResult is based on Code Table C232.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PostSecondaryCertLicensureResultDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PostSecondaryCertLicensureResultDescriptor', @level2type=N'COLUMN', @level2name=N'PostSecondaryCertLicensureResultDescriptorId'
GO

-- Extended Properties [tx].[PreferredHomeCommunicationMethodDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PreferredHomeCommunicationMethod identifies the preferred unique communication method used by the child at home. (C313)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PreferredHomeCommunicationMethodDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PreferredHomeCommunicationMethodDescriptor', @level2type=N'COLUMN', @level2name=N'PreferredHomeCommunicationMethodDescriptorId'
GO

-- Extended Properties [tx].[PriorYearActualExt] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The ActualExtension Domain Entity represents the sum of the financial transactions to date relating to a specific account.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearActualExt'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0317, C146. Function identifies a general operational area and groups together related activities.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearActualExt', @level2type=N'COLUMN', @level2name=N'ActualFunctionDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0316, C145. Fund identifies the fund group and specific fund (when applicable) for actual financial data.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearActualExt', @level2type=N'COLUMN', @level2name=N'ActualFundDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0318, C159. Object identifies an account, a transaction, or a source of funds.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearActualExt', @level2type=N'COLUMN', @level2name=N'ActualObjectDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0320, C147. ProgramIntent identifies the cost of instruction and other services that are directed toward a particular need of a specific set of students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearActualExt', @level2type=N'COLUMN', @level2name=N'ActualProgramIntentDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearActualExt', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0974. FiscalYear is the last digit of the fiscal year, e.g., the fiscal year is 6 for the 2015-16 fiscal year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearActualExt', @level2type=N'COLUMN', @level2name=N'FiscalYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0319. Organization identifies the unique organizational unit within the district with which the account is associated.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearActualExt', @level2type=N'COLUMN', @level2name=N'Organization'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0774. ActualAmount indicates the dollar value associated with actual financial account information.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearActualExt', @level2type=N'COLUMN', @level2name=N'ActualAmount'
GO

-- Extended Properties [tx].[PriorYearLeaver] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PriorYearLeaver - This entity is being reported on non-enrolled students and graduates that are enrolled in the prior school year and do not return in the current school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3007, C324. AsOfStatusLastFridayOctober indicates the student''s status in the local education agency on the last Friday in October in the current school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'AsOfStatusLastFridayOctoberDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1596. AssociateDegreeIndicator indicates that the student earned an associate degree by August 31 immediately following graduation.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'AssociateDegreeIndicatorDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The city the student was born in.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'BirthCity'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The country in which an individual is born. It is strongly recommended that entries use only ISO 3166 2-letter country codes.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'BirthCountryDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year on which an individual was born.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'BirthDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For students born outside of the U.S., the Province or jurisdiction in which an individual is born.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'BirthInternationalProvince'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A person''s gender at birth.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'BirthSexDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The abbreviation for the name of the state (within the United States) or extra-state jurisdiction in which an individual was born.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'BirthStateAbbreviationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For students born outside of the U.S., the date the student entered the U.S.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'DateEnteredUS'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3028. The ExitWithdrawDate is the month, day, and year of the first day after an individual''s last attendance at school (if known), the date on which an individual graduated, or the date it becomes known officially that an individual left school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'ExitWithdrawDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This descriptor defines the circumstances under which the student exited from membership in an educational institution.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'ExitWithdrawTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1724, C230. The FinancialAidApplication indicates the manner in which the student completed the graduation requirement of either completing a financial aid application (Free application for Federal Student Aid (FAFSA) or Texas Application for State Financial Aid (TASFA)) or submitting an exemption.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'FinancialAidApplicationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A name given to an individual at birth, baptism, or during another naming ceremony, or through legal change.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'FirstName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0706, C012. GenerationCode identifies the generation suffix, if any, which the person attaches to his name.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'GenerationCodeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An appendage, if any, used to denote an individual''s generation in his family (e.g., Jr., Sr., III).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'GenerationCodeSuffix'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This descriptor defines the set of grade levels. The map to known Ed-Fi enumeration values is required.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'GradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1064. HispanicLatinoEthnicity is an indication that the individual traces his or her origin or descent to Mexico, Puerto Rico, Cuba, Central and South America, and other Spanish cultures, regardless of race. The term, "Spanish origin," can be used in addition to "Hispanic or Latino."', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'HispanicLatinoEthnicity'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name borne in common by members of a family.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'LastSurname'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0923. LocalStudentId is the student''s local identification number as assigned by the local education agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'LocalStudentId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The individual''s maiden name.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'MaidenName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A secondary name given to an individual at birth, baptism, or during another naming ceremony.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'MiddleName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicator of whether the student was born with other siblings (i.e., twins, triplets, etc.)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'MultipleBirthStatus'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A prefix used to denote the title, degree, position, or seniority of the individual.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'PersonalTitlePrefix'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A person''s gender.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'SexDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0001. StudentId is the student''s Social Security number or a state-approved alternative identification number.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaver', @level2type=N'COLUMN', @level2name=N'StudentId'
GO

-- Extended Properties [tx].[PriorYearLeaverAddress] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The set of elements that describes an address, including the street address, city, state, and ZIP code.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of address listed for an individual or organization.    For example:  Physical Address, Mailing Address, Home Address, etc.)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'AddressTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The apartment, room, or suite number of an address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'ApartmentRoomSuiteNumber'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The number of the building on the site, if more than one building shares the same address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'BuildingSiteNumber'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the city in which an address is located.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'City'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The congressional district in which an address is located.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'CongressionalDistrict'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The Federal Information Processing Standards (FIPS) numeric code for the county issued by the National Institute of Standards and Technology (NIST). Counties are considered to be the "first-order subdivisions" of each State and statistically equivalent entity, regardless of their local designations (county, parish, borough, etc.) Counties in different States will have the same code. A unique county number is created when combined with the 2-digit FIPS State Code.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'CountyFIPSCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An indication that the address should not be published.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'DoNotPublishIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The geographic latitude of the physical address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'Latitude'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A general geographic indicator that categorizes U.S. territory (e.g., City, Suburban).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'LocaleDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The geographic longitude of the physical address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'Longitude'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the county, parish, borough, or comparable unit (within a state) in
                      ''which an address is located.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'NameOfCounty'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The five or nine digit zip code or overseas postal code portion of an address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'PostalCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The abbreviation for the state (within the United States) or outlying area in which an address is located.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'StateAbbreviationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The street number and street name or post office box number of an address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddress', @level2type=N'COLUMN', @level2name=N'StreetNumberName'
GO

-- Extended Properties [tx].[PriorYearLeaverAddressPeriod] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The time periods for which the address is valid. For physical addresses, the periods in which the person lived at that address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddressPeriod'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddressPeriod', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddressPeriod', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year for the start of the period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddressPeriod', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year for the end of the period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverAddressPeriod', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[PriorYearLeaverElectronicMail] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The numbers, letters, and symbols used to identify an electronic mail (e-mail) user within the network to which the individual or organization belongs.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverElectronicMail'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverElectronicMail', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverElectronicMail', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The electronic mail (e-mail) address listed for an individual or organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverElectronicMail', @level2type=N'COLUMN', @level2name=N'ElectronicMailAddress'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of email listed for an individual or organization. For example: Home/Personal, Work, etc.)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverElectronicMail', @level2type=N'COLUMN', @level2name=N'ElectronicMailTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An indication that the electronic email address should not be published.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverElectronicMail', @level2type=N'COLUMN', @level2name=N'DoNotPublishIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An indication that the electronic mail address should be used as the principal electronic mail address for an individual or organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverElectronicMail', @level2type=N'COLUMN', @level2name=N'PrimaryEmailAddressIndicator'
GO

-- Extended Properties [tx].[PriorYearLeaverEndorsementCompleted] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3021, C332. EndorsementCompleted indicates the student has successfully completed a Foundation High School Program to earn a STEM, Business and Industry, Public Services, Arts and Humanities, or Multi-Disciplinary Studies endorsement.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverEndorsementCompleted'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverEndorsementCompleted', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverEndorsementCompleted', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3021, C332. EndorsementCompleted indicates the student has successfully completed a Foundation High School Program to earn a STEM, Business and Industry, Public Services, Arts and Humanities, or Multi-Disciplinary Studies endorsement.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverEndorsementCompleted', @level2type=N'COLUMN', @level2name=N'EndorsementCompletedDescriptorId'
GO

-- Extended Properties [tx].[PriorYearLeaverGraduationSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This educational entity represents the conferring or certification by an educational organization that the student has successfully completed a particular course of study. It represents the electronic version of its physical document counterpart.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverGraduationSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverGraduationSet', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverGraduationSet', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The category of achievement attributed to the learner.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverGraduationSet', @level2type=N'COLUMN', @level2name=N'AchievementCategoryDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0791. DiplomaAwardDate indicates the month and year that the student graduated from high school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverGraduationSet', @level2type=N'COLUMN', @level2name=N'DiplomaAwardDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0806, C062. DiplomaType indicates the type of plan under which the student graduated.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverGraduationSet', @level2type=N'COLUMN', @level2name=N'DiplomaTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3089. DistingLevelAchievementGraduate indicates the student has successfully completed the distinguished level of achievement as provided by TEC §28.025 (b-15) or TEC §28.0253.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverGraduationSet', @level2type=N'COLUMN', @level2name=N'DistingLevelAchievementGraduate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1562. IndividualGraduationCommitteeGraduateIndicator Indicates whether a student for whom an IGC was established has graduated based on an IGC decision.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverGraduationSet', @level2type=N'COLUMN', @level2name=N'IndividualGraduationCommitteeGraduateIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1736, C233. TexasFirstEarlyHSCompletionProgram indicates the student graduated early under the Texas First Early High School Completion Program and specifies whether the student graduated two or more semesters or less than two semesters or equivalent earlier than the expected graduation date of the student''s high school cohort.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverGraduationSet', @level2type=N'COLUMN', @level2name=N'TexasFirstEarlyHSCompletionProgramDescriptorId'
GO

-- Extended Properties [tx].[PriorYearLeaverIndustryBasedCertificationSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Common Type IndustryBasedCertificationSet.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverIndustryBasedCertificationSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1632. DateCertTaken indicates the date upon which the industry based certification was taken.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'DateCertTaken'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1655, C226. IBCVendorCode identifies the organization or company that offered the service.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'IBCVendorDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1640, C214. PostSecondaryCertificationLicensure indicates a nationally or internationally recognized business or industry certification or license earned by a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'PostSecondaryCertificationLicensureDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1733, C232. PostSecondaryCertLicensureResult indicates the result of a state, nationally, or internationally recognized industry-based certification exam taken by a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'PostSecondaryCertLicensureResultDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3133. IBCBackgroundCheckCost identifies the amount of money that was paid for the background check (fingerprinting or criminal history record information reveiw) associated to an Industry-Based Certification passed/earned by a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'IBCBackgroundCheckCost'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1654. IBCExamFeeAmount identifies the amount of money that was paid for a student''s industry certification exam by the local education agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'IBCExamFeeAmount'
GO

-- Extended Properties [tx].[PriorYearLeaverLanguage] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3033, C092. Language indicates the language used in the student’s home and the language used by the student, as determined by the student’s home language survey. (see 19 TAC §89.1215).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverLanguage'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverLanguage', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverLanguage', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A specification of which written or spoken communication is being used.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverLanguage', @level2type=N'COLUMN', @level2name=N'LanguageDescriptorId'
GO

-- Extended Properties [tx].[PriorYearLeaverLanguageUse] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A description of how the language is used (e.g. Home Language, Native Language, Spoken Language).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverLanguageUse'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverLanguageUse', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverLanguageUse', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A specification of which written or spoken communication is being used.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverLanguageUse', @level2type=N'COLUMN', @level2name=N'LanguageDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A description of how the language is used (e.g. Home Language, Native Language, Spoken Language).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverLanguageUse', @level2type=N'COLUMN', @level2name=N'LanguageUseDescriptorId'
GO

-- Extended Properties [tx].[PriorYearLeaverParent] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This entity represents a parent or guardian of a student, such as mother, father, or caretaker, for a prior year leaver.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3078. ParentUId is a unique number or alphanumeric code assigned to a person by the LEA.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParent', @level2type=N'COLUMN', @level2name=N'ParentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A name given to an individual at birth, baptism, or during another naming ceremony, or through legal change.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParent', @level2type=N'COLUMN', @level2name=N'FirstName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0706, C012. GenerationCode identifies the generation suffix, if any, which the person attaches to his name (e.g., Jr., Sr., III).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParent', @level2type=N'COLUMN', @level2name=N'GenerationCodeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An appendage, if any, used to denote an individual''s generation in his family (e.g., Jr., Sr., III).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParent', @level2type=N'COLUMN', @level2name=N'GenerationCodeSuffix'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name borne in common by members of a family.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParent', @level2type=N'COLUMN', @level2name=N'LastSurname'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The individual''s maiden name.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParent', @level2type=N'COLUMN', @level2name=N'MaidenName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A secondary name given to an individual at birth, baptism, or during another naming ceremony.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParent', @level2type=N'COLUMN', @level2name=N'MiddleName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A prefix used to denote the title, degree, position, or seniority of the individual.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParent', @level2type=N'COLUMN', @level2name=N'PersonalTitlePrefix'
GO

-- Extended Properties [tx].[PriorYearLeaverParentAddress] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The set of elements that describes an address, including the street address, city, state, and ZIP code.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3078. ParentUId is a unique number or alphanumeric code assigned to a person by the LEA.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'ParentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of address listed for an individual or organization.    For example:  Physical Address, Mailing Address, Home Address, etc.)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'AddressTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The apartment, room, or suite number of an address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'ApartmentRoomSuiteNumber'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The number of the building on the site, if more than one building shares the same address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'BuildingSiteNumber'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the city in which an address is located.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'City'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The congressional district in which an address is located.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'CongressionalDistrict'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The Federal Information Processing Standards (FIPS) numeric code for the county issued by the National Institute of Standards and Technology (NIST). Counties are considered to be the "first-order subdivisions" of each State and statistically equivalent entity, regardless of their local designations (county, parish, borough, etc.) Counties in different States will have the same code. A unique county number is created when combined with the 2-digit FIPS State Code.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'CountyFIPSCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An indication that the address should not be published.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'DoNotPublishIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The geographic latitude of the physical address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'Latitude'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A general geographic indicator that categorizes U.S. territory (e.g., City, Suburban).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'LocaleDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The geographic longitude of the physical address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'Longitude'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the county, parish, borough, or comparable unit (within a state) in
                      ''which an address is located.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'NameOfCounty'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The five or nine digit zip code or overseas postal code portion of an address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'PostalCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The abbreviation for the state (within the United States) or outlying area in which an address is located.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'StateAbbreviationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The street number and street name or post office box number of an address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddress', @level2type=N'COLUMN', @level2name=N'StreetNumberName'
GO

-- Extended Properties [tx].[PriorYearLeaverParentAddressPeriod] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The time periods for which the address is valid. For physical addresses, the periods in which the person lived at that address.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddressPeriod'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3078. ParentUId is a unique number or alphanumeric code assigned to a person by the LEA.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddressPeriod', @level2type=N'COLUMN', @level2name=N'ParentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year for the start of the period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddressPeriod', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year for the end of the period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentAddressPeriod', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[PriorYearLeaverParentElectronicMail] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The numbers, letters, and symbols used to identify an electronic mail (e-mail) user within the network to which the individual or organization belongs.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentElectronicMail'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3078. ParentUId is a unique number or alphanumeric code assigned to a person by the LEA.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentElectronicMail', @level2type=N'COLUMN', @level2name=N'ParentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An indication that the electronic email address should not be published.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentElectronicMail', @level2type=N'COLUMN', @level2name=N'DoNotPublishIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The electronic mail (e-mail) address listed for an individual or organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentElectronicMail', @level2type=N'COLUMN', @level2name=N'ElectronicMailAddress'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of email listed for an individual or organization. For example: Home/Personal, Work, etc.)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentElectronicMail', @level2type=N'COLUMN', @level2name=N'ElectronicMailTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An indication that the electronic mail address should be used as the principal electronic mail address for an individual or organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentElectronicMail', @level2type=N'COLUMN', @level2name=N'PrimaryEmailAddressIndicator'
GO

-- Extended Properties [tx].[PriorYearLeaverParentPersonalIdentificationDocument] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The documents presented as evident to verify one''s personal identity; for example: drivers license, passport, birth certificate, etc.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentPersonalIdentificationDocument'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3078. ParentUId is a unique number or alphanumeric code assigned to a person by the LEA.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'ParentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The primary function of the document used for establishing identity.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IdentificationDocumentUseDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The category of the document relative to its purpose.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'PersonalInformationVerificationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The day when the document  expires, if null then never expires.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'DocumentExpirationDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The title of the document given by the issuer.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'DocumentTitle'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Country of origin of the document. It is strongly recommended that entries use only ISO 3166 2-letter country codes.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IssuerCountryDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The unique identifier on the issuer''s identification system.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IssuerDocumentIdentificationCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the entity or institution that issued the document.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IssuerName'
GO

-- Extended Properties [tx].[PriorYearLeaverParentTelephone] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The 10-digit telephone number, including the area code, of an individual or organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentTelephone'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3078. ParentUId is a unique number or alphanumeric code assigned to a person by the LEA.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentTelephone', @level2type=N'COLUMN', @level2name=N'ParentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An indication that the telephone number should not be published.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentTelephone', @level2type=N'COLUMN', @level2name=N'DoNotPublishIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The order of priority assigned to telephone numbers to define which number to attempt first, second, etc.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentTelephone', @level2type=N'COLUMN', @level2name=N'OrderOfPriority'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The telephone number including the area code, and extension, if applicable.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentTelephone', @level2type=N'COLUMN', @level2name=N'TelephoneNumber'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of communication number listed for an individual or organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentTelephone', @level2type=N'COLUMN', @level2name=N'TelephoneNumberTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An indication that the telephone number is technically capable of sending and receiving Short Message Service (SMS) text messages.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverParentTelephone', @level2type=N'COLUMN', @level2name=N'TextMessageCapabilityIndicator'
GO

-- Extended Properties [tx].[PriorYearLeaverPersonalIdentificationDocument] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The documents presented as evident to verify one''s personal identity; for example: drivers license, passport, birth certificate, etc.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverPersonalIdentificationDocument'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The primary function of the document used for establishing identity.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IdentificationDocumentUseDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The category of the document relative to its purpose.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'PersonalInformationVerificationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The day when the document  expires, if null then never expires.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'DocumentExpirationDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The title of the document given by the issuer.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'DocumentTitle'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Country of origin of the document. It is strongly recommended that entries use only ISO 3166 2-letter country codes.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IssuerCountryDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The unique identifier on the issuer''s identification system.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IssuerDocumentIdentificationCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the entity or institution that issued the document.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IssuerName'
GO

-- Extended Properties [tx].[PriorYearLeaverRace] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The enumeration items defining the racial categories which most clearly reflects the individual''s recognition of his or her community or with which the individual most identifies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverRace'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverRace', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverRace', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The enumeration items defining the racial categories which most clearly reflects the individual''s recognition of his or her community or with which the individual most identifies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverRace', @level2type=N'COLUMN', @level2name=N'RaceDescriptorId'
GO

-- Extended Properties [tx].[PriorYearLeaverStudentParentAssociation] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This association relates prior year leavers to their parents, guardians, or caretakers, as they were reported in the prior year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverStudentParentAssociation'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3078. ParentUId is a unique number or alphanumeric code assigned to a person by the LEA.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverStudentParentAssociation', @level2type=N'COLUMN', @level2name=N'ParentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverStudentParentAssociation', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverStudentParentAssociation', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1427. ContactPriority indicates the numeric order of the preferred sequence or priority of contact.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverStudentParentAssociation', @level2type=N'COLUMN', @level2name=N'ContactPriority'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The nature of an individual''s relationship to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverStudentParentAssociation', @level2type=N'COLUMN', @level2name=N'RelationDescriptorId'
GO

-- Extended Properties [tx].[PriorYearLeaverTelephone] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The 10-digit telephone number, including the area code, of an individual or organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverTelephone'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverTelephone', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverTelephone', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The telephone number including the area code, and extension, if applicable.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverTelephone', @level2type=N'COLUMN', @level2name=N'TelephoneNumber'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of communication number listed for an individual or organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverTelephone', @level2type=N'COLUMN', @level2name=N'TelephoneNumberTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An indication that the telephone number should not be published.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverTelephone', @level2type=N'COLUMN', @level2name=N'DoNotPublishIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The order of priority assigned to telephone numbers to define which number to attempt first, second, etc.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverTelephone', @level2type=N'COLUMN', @level2name=N'OrderOfPriority'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An indication that the telephone number is technically capable of sending and receiving Short Message Service (SMS) text messages.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearLeaverTelephone', @level2type=N'COLUMN', @level2name=N'TextMessageCapabilityIndicator'
GO

-- Extended Properties [tx].[PriorYearSSAOrgAssociationExt] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The PriorYearSSAOrgAssociationExt entity identifies the Education Service Center (ESC) or Local Education Agency (LEA) fiscal agent(s) and the ESC or LEA member(s) for each type of shared services arrangement (SSA) that exists among two or more ESCs and LEAs.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearSSAOrgAssociationExt'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearSSAOrgAssociationExt', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0777. FiscalAgentDistrictID is the county-district number of the shared services arrangement fiscal agent registered with the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearSSAOrgAssociationExt', @level2type=N'COLUMN', @level2name=N'FiscalAgentDistrictId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0776A, C049A. PriorYearSSAType indicates the type of program or service a shared services arrangement provided.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearSSAOrgAssociationExt', @level2type=N'COLUMN', @level2name=N'PriorYearSSATypeDescriptorId'
GO

-- Extended Properties [tx].[PriorYearSSATypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor PriorYearSSAType is populated from Code Table C049A.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearSSATypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'PriorYearSSATypeDescriptor', @level2type=N'COLUMN', @level2name=N'PriorYearSSATypeDescriptorId'
GO

-- Extended Properties [tx].[ProgramOfStudyDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ProgramOfStudy is populated from code table C220.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ProgramOfStudyDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ProgramOfStudyDescriptor', @level2type=N'COLUMN', @level2name=N'ProgramOfStudyDescriptorId'
GO

-- Extended Properties [tx].[RegionalDaySchoolProgramForDeafDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor RegionalDaySchoolProgramForDeaf is based on code table C067.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'RegionalDaySchoolProgramForDeafDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'RegionalDaySchoolProgramForDeafDescriptor', @level2type=N'COLUMN', @level2name=N'RegionalDaySchoolProgramForDeafDescriptorId'
GO

-- Extended Properties [tx].[ReportAssessmentTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ReportAssessmentType is populated from code table C306.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportAssessmentTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportAssessmentTypeDescriptor', @level2type=N'COLUMN', @level2name=N'ReportAssessmentTypeDescriptorId'
GO

-- Extended Properties [tx].[ReportingPeriodDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ReportingPeriod is populated from Code Table C130.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportingPeriodDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportingPeriodDescriptor', @level2type=N'COLUMN', @level2name=N'ReportingPeriodDescriptorId'
GO

-- Extended Properties [tx].[ReportingPeriodExt] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The ActualExtension Domain Entity represents the sum of the financial transactions to date relating to a specific account.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportingPeriodExt'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the calendar.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportingPeriodExt', @level2type=N'COLUMN', @level2name=N'CalendarCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year of the calendar event.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportingPeriodExt', @level2type=N'COLUMN', @level2name=N'Date'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0934, C130. ReportingPeriod indicates the period for which the attendance data are being reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportingPeriodExt', @level2type=N'COLUMN', @level2name=N'ReportingPeriodDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportingPeriodExt', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year associated with the calendar.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportingPeriodExt', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3010. BeginDate indicates the month, day, and year for the specified data element becomes true of the student, staff, program, etc.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportingPeriodExt', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3020. EndDate indicates the month, day, and year for the specified data element becomes false of the student, staff, program, etc.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportingPeriodExt', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0935. NumberDaysTaught indicates the number of days of instruction offered, as shown on the school calendar, during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ReportingPeriodExt', @level2type=N'COLUMN', @level2name=N'NumberDaysTaught'
GO

-- Extended Properties [tx].[RestraintEventExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'RestraintEventExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique number or alphanumeric code assigned to a restraint event by a school, school system, state, or other agency or entity.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'RestraintEventExtension', @level2type=N'COLUMN', @level2name=N'RestraintEventIdentifier'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'RestraintEventExtension', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'RestraintEventExtension', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1725. NonMembershipDisciplineRestraintIndicator indicates the discipline incident or restraint event being reported is for a special education student enrolled, not in membership.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'RestraintEventExtension', @level2type=N'COLUMN', @level2name=N'NonMembershipDisciplineRestraintIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1516, C194. RestraintStaffType indicates the kind of school staff person that performed a student restraint.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'RestraintEventExtension', @level2type=N'COLUMN', @level2name=N'RestraintStaffTypeDescriptorId'
GO

-- Extended Properties [tx].[RestraintStaffTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor RestraintStaffType indicates the kind of school staff person that performed a student restraint. (C194)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'RestraintStaffTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'RestraintStaffTypeDescriptor', @level2type=N'COLUMN', @level2name=N'RestraintStaffTypeDescriptorId'
GO

-- Extended Properties [tx].[SchoolCampusEnrollmentTypeSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CampusEnrollmentType with effective dates', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolCampusEnrollmentTypeSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolCampusEnrollmentTypeSet', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the CampusEnrollmentType', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolCampusEnrollmentTypeSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1641, C219. CampusEnrollmentType specifies the method by which the campus draws student enrollment.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolCampusEnrollmentTypeSet', @level2type=N'COLUMN', @level2name=N'CampusEnrollmentTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a campus was assigned to the CampusEnrollmentType descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolCampusEnrollmentTypeSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[SchoolCharterWaitlistSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CharterWaitlist with effective dates', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolCharterWaitlistSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolCharterWaitlistSet', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1676. CharterAdmissionWaitlist indicates whether the charter school campus uses a waitlist for admission.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolCharterWaitlistSet', @level2type=N'COLUMN', @level2name=N'CharterAdmissionWaitlist'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1675. CharterEducationalEnrollmentCapacity indicates the number of students to which the charter school’s campus is able to provide instruction without exceeding staffing and facility limitations and the approved charter holder''s maximum enrollment.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolCharterWaitlistSet', @level2type=N'COLUMN', @level2name=N'CharterEducationalEnrollmentCapacity'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1674. NumberCharterStudentsEnrolled indicates the number of students enrolled at a charter school’s campus as of the last Friday in September.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolCharterWaitlistSet', @level2type=N'COLUMN', @level2name=N'NumberCharterStudentsEnrolled'
GO

-- Extended Properties [tx].[SchoolELOSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ELOSet captures data (with effective dates) for school participation in expanded learning opportunities.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolELOSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolELOSet', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1614, C218. ELOType indicates the type of expanded learning opportunity (ELO) program offered at the campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolELOSet', @level2type=N'COLUMN', @level2name=N'ELOTypeDescriptorId'
GO

-- Extended Properties [tx].[SchoolELOSetELOActivitySet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Collection of SchoolELOActivity. For each expanded learning opportunity offered by a school, more than one ELO activity can be reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolELOSetELOActivitySet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolELOSetELOActivitySet', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1614, C218. ELOType indicates the type of expanded learning opportunity (ELO) program offered at the campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolELOSetELOActivitySet', @level2type=N'COLUMN', @level2name=N'ELOTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1719, C229. ELOActivity indicates the specific Expanded Learning Opportunity (ELO) activity offered at the campus', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolELOSetELOActivitySet', @level2type=N'COLUMN', @level2name=N'ELOActivityDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1720. ELODaysScheduledPerYear indicates the number of days the Expanded Learning Opportunity (ELO) activity is offered during the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolELOSetELOActivitySet', @level2type=N'COLUMN', @level2name=N'ELODaysScheduledPerYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1621. ELOMinutesScheduledPerDay indicates the number of minutes scheduled each day for a given ELOActivity.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolELOSetELOActivitySet', @level2type=N'COLUMN', @level2name=N'ELOMinutesScheduledPerDay'
GO

-- Extended Properties [tx].[SchoolExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolExtension', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1671. AdditionalDaysProgram indicates whether the campus implemented an Additional Days School Year (ADSY) program for any students in prekindergarten through eighth grades as described in TEC §48.0051.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolExtension', @level2type=N'COLUMN', @level2name=N'AdditionalDaysProgram'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1613. ExpandedLearningOpportunity indicates if the campus offers any expanded learning opportunity (ELO) as listed in TEC 33.252.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolExtension', @level2type=N'COLUMN', @level2name=N'ExpandedLearningOpportunity'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1727. NumberOfBullyingIncidents indicates the number of reported incidents of bullying at each campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolExtension', @level2type=N'COLUMN', @level2name=N'NumberOfBullyingIncidents'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1727. NumberOfCyberbullyingIncidents indicates the number of reported incidents of cyberbullying at each campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolExtension', @level2type=N'COLUMN', @level2name=N'NumberOfCyberbullyingIncidents'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1646. PKFullDayWaiver indicates whether the campus has received an exemption from offering a full-day prekindergarten program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolExtension', @level2type=N'COLUMN', @level2name=N'PKFullDayWaiver'
GO

-- Extended Properties [tx].[SchoolNSLPTypeSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'NSLPType with effective dates', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolNSLPTypeSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolNSLPTypeSet', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the NSLPType', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolNSLPTypeSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a campus was assigned to the NSLPType descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolNSLPTypeSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1591, C212. NSLPType indicates a campus''s  National School Lunch Program (NSLP) participation status.  The NSLP provides reimbursement to schools for free or reduced-price meals based on student eligibility.  Options for claiming reimbursement under the NSLP include:  eligibility determined at the individual student/family level (participation in NSLP without using any Provision or the Community Eligibility Program) or at the campus/community level (Provision 2 or Community Eligibility Program).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SchoolNSLPTypeSet', @level2type=N'COLUMN', @level2name=N'NSLPTypeDescriptorId'
GO

-- Extended Properties [tx].[SectionSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Extensions to Section with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The local code assigned by the School that identifies the course offering provided for the instruction of students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'LocalCourseCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The local identifier assigned to a section.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'SectionIdentifier'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the calendar for the academic session.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'SessionName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year for the start of the period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3059, C342. SPEDStudentAgeRange identifies the age range of students receiving special education services that teaching and paraprofessional staff provide services to.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'SPEDStudentAgeRangeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1726. ChildCareOperationNumber identifies the childcare facility operation number assigned by the Child Care Regulation (CCR) department. The facility serves students who are dually enrolled in the Local Education Agency''s public prekindergarten course section and childcare program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'ChildCareOperationNumber'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1055, C179. ClassType identifies the type of class providing instruction to students in particular class settings.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'ClassTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0948, C135. CourseSequence identifies the unique part(s) of a course when a course is taught during a single grading period or semester or across multiple grading periods or semesters.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'CourseSequenceDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3011. CTEHours indicate the number of contact hours assigned to a particular section of a course.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'CTEHours'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day in the current school year the data elements in the SectionSet were associated to the section.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1580. HighQualityPKProgram indicates campus/course/section participation in the High-Quality Prekindergarten Program consistent with requirements in TEC §29.167-29.171.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'HighQualityPKProgram'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1072, C182. NonCampusBasedInstruction indicates that a course was offered for class credit or student achievement, but 1) was not taught by a school district/charter school employee or a contracted teacher, or 2) was taught by a school district/charter school employee or a contracted teacher at a facility other than the campus where the student is enrolled.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'NonCampusBasedInstructionDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1579, C206. PKCurricula indicates curricula used in the district''s prekindergarten program section TEC 29.1532(c)(6).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'PKCurriculaDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1555, C310. PKSchoolType indicates the type of prekindergarten program that is offered.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'PKSchoolTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1558, C311. StudentInstruction indicates the PK student type of instruction.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'PKStudentInstructionDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0747, C030. PopulationServed identifies the student population for which a service has been designed or is intended. It does not necessarily identify the program eligibility of the students who receive the service.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SectionSet', @level2type=N'COLUMN', @level2name=N'PopulationServedDescriptorId'
GO

-- Extended Properties [tx].[SharedServiceArrangementExt] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The SharedServiceArrangementExtension Domain Entity represents the sum of the financial transactions to date for shared service arrangements.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SharedServiceArrangementExt'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SharedServiceArrangementExt', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0974. FiscalYear is the last digit of the fiscal year, e.g., the fiscal year is 4 for the 2013-14 fiscal year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SharedServiceArrangementExt', @level2type=N'COLUMN', @level2name=N'FiscalYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0316S, C145S. SSAFund identifies the fund group and specific fund (when applicable) for the shared service arrangement actual financial data.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SharedServiceArrangementExt', @level2type=N'COLUMN', @level2name=N'SSAFundDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0981. SSAMemberDistrictID indicates the county-district number of the school district (as registered with the Texas Education Agency) which is a member district in the shared services arrangement.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SharedServiceArrangementExt', @level2type=N'COLUMN', @level2name=N'SSAMemberDistrictId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0776, C049. SSAType indicates the type of program or service provided by a shared services arrangement.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SharedServiceArrangementExt', @level2type=N'COLUMN', @level2name=N'SSATypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0774. ActualAmount indicates the dollar value associated with actual financial account information.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SharedServiceArrangementExt', @level2type=N'COLUMN', @level2name=N'ActualAmount'
GO

-- Extended Properties [tx].[SharedServiceArrangementStaffDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor SharedServiceArrangementStaff is populated from code table C169', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SharedServiceArrangementStaffDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SharedServiceArrangementStaffDescriptor', @level2type=N'COLUMN', @level2name=N'SharedServiceArrangementStaffDescriptorId'
GO

-- Extended Properties [tx].[SpecialEducationProgramReportingPeriodAttendance] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This extended entity represents the special education program attendance of a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0975. CalendarCode indicates a unique campus calendar of school days for a particular group of students on a campus. Students with the same instructional track have the same number of days taught in a particular reporting period at a campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'CalendarCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0017, C050. GradeLevel indicates the current grade level of the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'GradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0173, C035. InstructionalSetting identifies the setting used in providing instruction to students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'InstructionalSettingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0833. RegionalDaySchoolProgramForDeaf indicates the student is receiving instructional servies from the regional day school program for the deaf.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'RegionalDaySchoolProgramForDeafDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0934, C130. ReportingPeriod indicates the period for which the attendance data are being reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'ReportingPeriodDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0944. EligibleDaysPresentInInstrSetting indicates the number of days the student was eligible and present in a designated instructional setting during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'EligibleDaysPresentInInstrSetting'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0945. ExcessHoursInInstructionalSetting indicates the number of hours above the allowable six hours per day of combined career and technical education and special education and related services in a designated instructional setting during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'ExcessHoursInInstructionalSetting'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1527. LEAOfRDSPDService indicates the RDSPD Fiscal Agent district that provides the RDSPD service to a particular RDSPD student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'LEAOfRDSPDService'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0935. NumberDaysTaught indicates the number of days of instruction offered, as shown on the school calendar, during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialEducationProgramReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'NumberDaysTaught'
GO

-- Extended Properties [tx].[SpecialProgramsReportingPeriodAttendance] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This extended entity represents the recording of a student’s special programs reporting period attendance.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialProgramsReportingPeriodAttendance'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0975. CalendarCode indicates a unique campus calendar of school days for a particular group of students on a campus. Students with the same instructional track have the same number of days taught in a particular reporting period at a campus.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialProgramsReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'CalendarCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0017, C050. GradeLevel indicates the current grade level of the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialProgramsReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'GradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0934, C130. ReportingPeriod indicates the period for which the attendance data are being reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialProgramsReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'ReportingPeriodDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialProgramsReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialProgramsReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0935. NumberDaysTaught indicates the number of days of instruction offered, as shown on the school calendar, during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialProgramsReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'NumberDaysTaught'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0939. TotalEligPregRelSvcsDaysPresent indicates the total number of days a female student was present at school or served through Compensatory Education Home Instruction (CEHI) and an eligible recipient of pregnancy related services during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialProgramsReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'TotalEligPregRelSvcsDaysPresent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1652. TotalEligResidentialFacilityDaysPresent indicates the total number of days the student was present and eligible for LEA services while living in a Residential Facility during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialProgramsReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'TotalEligResidentialFacilityDaysPresent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0940. TotalEligSpEdMainstreamDaysPresent indicates the total number of days a student with a special education individualized education program which provided for the mainstream instructional arrangement/setting was present during a particular reporting period.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SpecialProgramsReportingPeriodAttendance', @level2type=N'COLUMN', @level2name=N'TotalEligSpEdMainstreamDaysPresent'
GO

-- Extended Properties [tx].[SPEDProgramSvcDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3058. SPEDProgramSvc defines the services provided by an education organization to populations of students associated with a special education program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SPEDProgramSvcDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SPEDProgramSvcDescriptor', @level2type=N'COLUMN', @level2name=N'SPEDProgramSvcDescriptorId'
GO

-- Extended Properties [tx].[SPEDStudentAgeRangeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3059. SPEDStudentAgeRange identifies the age range of students receiving special education services that teaching and paraprofessional staff provide services to.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SPEDStudentAgeRangeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SPEDStudentAgeRangeDescriptor', @level2type=N'COLUMN', @level2name=N'SPEDStudentAgeRangeDescriptorId'
GO

-- Extended Properties [tx].[SSAFundDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Fund is populated from Code Table C145S.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SSAFundDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SSAFundDescriptor', @level2type=N'COLUMN', @level2name=N'SSAFundDescriptorId'
GO

-- Extended Properties [tx].[SSAOrgAssociationExt] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The SSAOrgAssociationExtension Domain Entity identifies the ESC/LEA fiscal agents and the ESC and/or LEA member(s) for each type of shared services arrangement (SSA) that exists among two or more ESCs and or LEAs.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SSAOrgAssociationExt'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SSAOrgAssociationExt', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0777. FiscalAgentDistrictID is the county-district number of the shared services arrangement fiscal agent registered with the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SSAOrgAssociationExt', @level2type=N'COLUMN', @level2name=N'FiscalAgentDistrictId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0776, C049. SSAType indicates the type of program or service provided by the shared service arrangement.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SSAOrgAssociationExt', @level2type=N'COLUMN', @level2name=N'SSATypeDescriptorId'
GO

-- Extended Properties [tx].[SSATypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor SSAType is populated from Code Table C049.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SSATypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'SSATypeDescriptor', @level2type=N'COLUMN', @level2name=N'SSATypeDescriptorId'
GO

-- Extended Properties [tx].[StaffEducationOrganizationAssignmentAssociationExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Month, day, and year of the start or effective date of a staff member''s employment, contract, or relationship with the education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationExtension', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationExtension', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The titles of employment, official status, or rank of education staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationExtension', @level2type=N'COLUMN', @level2name=N'StaffClassificationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationExtension', @level2type=N'COLUMN', @level2name=N'StaffUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1015, C169. SharedServiceArrangementStaff indicates whether the StaffEducationOrganizationAssignmentAssociation or StaffSectionAssociation being reported is part of a shared services arrangement for which the education service center is the fiscal agent.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationExtension', @level2type=N'COLUMN', @level2name=N'SharedServiceArrangementStaffDescriptorId'
GO

-- Extended Properties [tx].[StaffEducationOrganizationAssignmentAssociationStaffServiceSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StaffServiceSet represents the non-instructional responsibilities of the associated staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Month, day, and year of the start or effective date of a staff member''s employment, contract, or relationship with the education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The titles of employment, official status, or rank of education staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet', @level2type=N'COLUMN', @level2name=N'StaffClassificationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet', @level2type=N'COLUMN', @level2name=N'StaffUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3059, C342. SPEDStudentAgeRange identifies the age range of students receiving special education services that teaching and paraprofessional staff provide services to.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet', @level2type=N'COLUMN', @level2name=N'SPEDStudentAgeRangeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3060. StaffServiceBeginDate indicates the month, day, and year the staff member began providing the particular services.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet', @level2type=N'COLUMN', @level2name=N'StaffServiceBeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0724, C021. StaffService refers to the services supplied by staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet', @level2type=N'COLUMN', @level2name=N'StaffServiceDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1057. MonthlyMinutes is the total minutes devoted to a particular service in a standard month. A standard month is the four weeks in October, including the PEIMS Fall snapshot date (last Friday in October).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet', @level2type=N'COLUMN', @level2name=N'MonthlyMinutes'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0170. NumberOfStudentsInClass indicates the number of students served in the class.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet', @level2type=N'COLUMN', @level2name=N'NumberOfStudentsInClass'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0747, C030. identifies the student population for which a student has been designed or is intended. It does not necessarily identify the program eligibility of the students who receive the service.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet', @level2type=N'COLUMN', @level2name=N'PopulationServedDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3061. StaffServiceEndDate is the first day after the last day a staff was assigned to the StaffService descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationAssignmentAssociationStaffServiceSet', @level2type=N'COLUMN', @level2name=N'StaffServiceEndDate'
GO

-- Extended Properties [tx].[StaffEducationOrganizationEmploymentAssociationAuxiliaryRoleIdSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'AuxiliaryRoleId with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationAuxiliaryRoleIdSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationAuxiliaryRoleIdSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Reflects the type of employment or contract.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationAuxiliaryRoleIdSet', @level2type=N'COLUMN', @level2name=N'EmploymentStatusDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year on which an individual was hired for a position.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationAuxiliaryRoleIdSet', @level2type=N'COLUMN', @level2name=N'HireDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationAuxiliaryRoleIdSet', @level2type=N'COLUMN', @level2name=N'StaffUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1594, C213. AuxiliaryRoleId identifies the capacity in which a non-exempt auxiliary employee serves.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationAuxiliaryRoleIdSet', @level2type=N'COLUMN', @level2name=N'AuxiliaryRoleIdDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the AuxiliaryRoleId', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationAuxiliaryRoleIdSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last day a nonexempt auxiliary staff was assigned to the AuxiliaryRoleId descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationAuxiliaryRoleIdSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[StaffEducationOrganizationEmploymentAssociationDaysEmployedSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'DaysEmployedSet common type captures PercentDaysEmployed, NumberDaysEmployed and the BeginDate and EndDate associated to the DaysEmployed.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationDaysEmployedSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationDaysEmployedSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Reflects the type of employment or contract.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationDaysEmployedSet', @level2type=N'COLUMN', @level2name=N'EmploymentStatusDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year on which an individual was hired for a position.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationDaysEmployedSet', @level2type=N'COLUMN', @level2name=N'HireDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationDaysEmployedSet', @level2type=N'COLUMN', @level2name=N'StaffUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3010. Begin date is the first day of the DaysEmployed.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationDaysEmployedSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3020. EndDate is the first day after the last day staff was assigned the PercentDayEmployed and NumberDaysEmployed.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationDaysEmployedSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0160. NumberDaysEmployed indicates the actual number of at-work days within the school year that a person is scheduled to work in the district. This number does not include holidays, weekends, and any other days the employee is not scheduled to work.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationDaysEmployedSet', @level2type=N'COLUMN', @level2name=N'NumberDaysEmployed'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0760. PercentDayEmployed is the percentage of a standard district workday for which the employee is hired to work. For an employee on contract, the percentage may be determined directly from the contract: full-time = ''100''; half-time = ''50''; and so on. For an employee who is not on contract, the percentage may be determined as follows. Example: The standard work day for the district is 7 hours. An employee is hired to work for 4 hours a day. This data element is coded as ''57'' for this employee because 4/7 = .571, which is rounded down.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffEducationOrganizationEmploymentAssociationDaysEmployedSet', @level2type=N'COLUMN', @level2name=N'PercentDayEmployed'
GO

-- Extended Properties [tx].[StaffExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension', @level2type=N'COLUMN', @level2name=N'StaffUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1721. CreditableYearOfService indicates a teacher (ROLE-ID 087) who currently qualifies for the TIA allotment or has been submitted by the LEA for a new or change of designation, and has been employed by the LEA and compensated or will be compensated by the LEA for a creditable year of service. (§153.1021)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension', @level2type=N'COLUMN', @level2name=N'CreditableYearOfService'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0706, E1303, C012, DC148. GenerationCode identifies the generation suffix, if any, which the person attaches to his name.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension', @level2type=N'COLUMN', @level2name=N'GenerationCodeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3130. LEADeterminedTRAEligibility indicates the local education agency (LEA) has determined the teacher (StaffClassification is 087) is employed by a school system and teaches not less than an average of four hours each day, in an academic instructional setting or a career and technology educational setting.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension', @level2type=N'COLUMN', @level2name=N'LEADeterminedTRAEligibility'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1581, C207. Each teacher of record for a prekindergarten program class serving eligible four-year-old students must be certified under Subchapter B, Chapter 21; and have one of the additional qualifications found in the C207 code table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension', @level2type=N'COLUMN', @level2name=N'PKTeacherRequirementDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3069. StaffDoNotReportTSDS indicates the staff should not be reported for TSDS state or federal data collections.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension', @level2type=N'COLUMN', @level2name=N'StaffDoNotReportTSDS'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0505. StaffID is the person''s Social Security number.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension', @level2type=N'COLUMN', @level2name=N'StaffId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1377. TotalYearsPriorTeachingExperience indicates the total number of years that an individual has previously held a teaching position in one or more education institutions.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension', @level2type=N'COLUMN', @level2name=N'TotalYearsPriorTeachingExperience'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0130. TotalYearsProfExperience indicates the number of verifiable years of creditable experience as specified in 19 TAC, Chapter 153.1021.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension', @level2type=N'COLUMN', @level2name=N'TotalYearsProfExperience'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0161. YearsExperienceInDistrict indicates the number of completed years that a person has been employed in any professional position in the current district or education service center, whether or not there has been any interruption in service.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension', @level2type=N'COLUMN', @level2name=N'YearsExperienceInDistrict'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3129. YearsTRATeachingExperience indicates the number of verifiable years of teaching experience as a classroom teacher as described in TEC §48.158.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffExtension', @level2type=N'COLUMN', @level2name=N'YearsTRATeachingExperience'
GO

-- Extended Properties [tx].[StaffParaprofessionalCertificationSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ParaprofessionalCertification with effective dates', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffParaprofessionalCertificationSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffParaprofessionalCertificationSet', @level2type=N'COLUMN', @level2name=N'StaffUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the StaffTypeSet', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffParaprofessionalCertificationSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the day after the last day a para-professional staff was certified.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffParaprofessionalCertificationSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1670. ParaprofessionalCertification indicates whether a paraprofessional staff person is certified.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffParaprofessionalCertificationSet', @level2type=N'COLUMN', @level2name=N'ParaprofessionalCertification'
GO

-- Extended Properties [tx].[StaffSectionAssociationExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Month, day, and year of a teacher''s assignment to the section. If blank, defaults to the first day of the first grading period for the section.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The local code assigned by the School that identifies the course offering provided for the instruction of students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'LocalCourseCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The local identifier assigned to a section.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'SectionIdentifier'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the calendar for the academic session.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'SessionName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'StaffUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1673. AdditionalDaysProgramTeacher indicates if a teacher is teaching students eligible for the additional days school year (ADSY) program as described in TEC §48.0051.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'AdditionalDaysProgramTeacher'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1057. is the total number of minutes devoted to a particular service in a standard month. A standard month is considered to be the four weeks in October including the PEIMS Fall snapshot date (last Friday in October).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'MonthlyMinutes'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1604. NumberDaysTaughtWeek1 indicates, for a physical education teaching staff responsibility, the number of days in which physical education instruction is provided for each course section by campus during the first week of the 4 weeks in October that includes the last Friday in October.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'NumberDaysTaughtWeek1'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1605. NumberDaysTaughtWeek2 indicates, for a physical education teaching staff responsibility, the number of days in which physical education instruction is provided for each course section by campus during the first week of the 4 weeks in October that includes the last Friday in October.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'NumberDaysTaughtWeek2'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1606. NumberDaysTaughtWeek3 indicates, for a physical education teaching staff responsibility, the number of days in which physical education instruction is provided for each course section by campus during the first week of the 4 weeks in October that includes the last Friday in October.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'NumberDaysTaughtWeek3'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1607. NumberDaysTaughtWeek4 indicates, for a physical education teaching staff responsibility, the number of days in which physical education instruction is provided for each course section by campus during the first week of the 4 weeks in October that includes the last Friday in October.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'NumberDaysTaughtWeek4'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1608. NumberMinutesTaughtWeek1 indicates, for a physical education teaching staff responsibility, the number of minutes in which physical education instruction is provided for each course section by campus during the first week of the 4 weeks in October that includes the last Friday in October.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'NumberMinutesTaughtWeek1'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1609. NumberMinutesTaughtWeek2 indicates, for a physical education teaching staff responsibility, the number of minutes in which physical education instruction is provided for each course section by campus during the first week of the 4 weeks in October that includes the last Friday in October.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'NumberMinutesTaughtWeek2'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1610. NumberMinutesTaughtWeek3 indicates, for a physical education teaching staff responsibility, the number of minutes in which physical education instruction is provided for each course section by campus during the first week of the 4 weeks in October that includes the last Friday in October.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'NumberMinutesTaughtWeek3'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1611. NumberMinutesTaughtWeek4 indicates, for a physical education teaching staff responsibility, the number of minutes in which physical education instruction is provided for each course section by campus during the first week of the 4 weeks in October that includes the last Friday in October.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'NumberMinutesTaughtWeek4'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0170. NumberOfStudentsInClass indicates the number of students served in the class', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'NumberOfStudentsInClass'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1015, C169. SharedServiceArrangementStaff indicates whether the StaffEducationOrganizationAssignmentAssociation or StaffSectionAssociation being reported is part of a shared services arrangement for which the education service center is the fiscal agent.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'SharedServiceArrangementStaffDescriptorId'
GO

-- Extended Properties [tx].[StaffServiceDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StaffService refers to the services supplied by staff. (C343)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffServiceDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffServiceDescriptor', @level2type=N'COLUMN', @level2name=N'StaffServiceDescriptorId'
GO

-- Extended Properties [tx].[StaffTeacherIncentiveAllotmentDesignation] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1722, C322. TeacherIncentiveAllotmentDesignationCode indicates a teacher (ROLE-ID 087) is an Active National Board Certified Teacher, holds a current designation (Recognized, Exemplary, or Master) and/or has been submitted by an LEA for a new or change of designation in the Teacher Incentive Allotment.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffTeacherIncentiveAllotmentDesignation'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffTeacherIncentiveAllotmentDesignation', @level2type=N'COLUMN', @level2name=N'StaffUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1722, C322. TeacherIncentiveAllotmentDesignationCode indicates a teacher (ROLE-ID 087) is an Active National Board Certified Teacher, holds a current designation (Recognized, Exemplary, or Master) and/or has been submitted by an LEA for a new or change of designation in the Teacher Incentive Allotment.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffTeacherIncentiveAllotmentDesignation', @level2type=N'COLUMN', @level2name=N'TeacherIncentiveAllotmentDesignationDescriptorId'
GO

-- Extended Properties [tx].[StaffTypeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StaffType indicates whether the staff person is on the local education agency payroll, is a contracted professional staff person (instructional and non-instructional), including staff of a charter management organization, or is a teacher (StaffClassification 087) employed at an in-district charter campus by an organization that has been granted a campus charter under TEC, Chapter 12, Subchapter C.(C181)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffTypeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffTypeDescriptor', @level2type=N'COLUMN', @level2name=N'StaffTypeDescriptorId'
GO

-- Extended Properties [tx].[StaffTypeSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StaffType with effective dates', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffTypeSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a staff.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffTypeSet', @level2type=N'COLUMN', @level2name=N'StaffUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the StaffTypeSet', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffTypeSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last day a staff was assigned to the StaffType descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffTypeSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1073, C181. StaffType indicates whether the staff person is on the local education agency payroll, is a contracted professional staff person (instructional and non-instructional), including staff of a charter management organization, or is a teacher (StaffClassification 087) employed at an in-district charter campus by an organization that has been granted a campus charter under TEC, Chapter 12, Subchapter C.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StaffTypeSet', @level2type=N'COLUMN', @level2name=N'StaffTypeDescriptorId'
GO

-- Extended Properties [tx].[StudentAcademicRecordAssociateDegreeIndicatorSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The AssociateDegreeIndicatorSet common type represents the associate degree earned by a student and the date the student earned the associate degree. More than one AssociateDegreeIndicatorSet common type can be reported for a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordAssociateDegreeIndicatorSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordAssociateDegreeIndicatorSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordAssociateDegreeIndicatorSet', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordAssociateDegreeIndicatorSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The term for the session during the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordAssociateDegreeIndicatorSet', @level2type=N'COLUMN', @level2name=N'TermDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1596, C235. AssociateDegreeIndicator indicates that the student earned an associate degree by August 31 immediately following graduation.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordAssociateDegreeIndicatorSet', @level2type=N'COLUMN', @level2name=N'AssociateDegreeIndicatorDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3123. EarnedDate is the first instructional day a student earned an associate degree.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordAssociateDegreeIndicatorSet', @level2type=N'COLUMN', @level2name=N'EarnedDate'
GO

-- Extended Properties [tx].[StudentAcademicRecordDiplomaExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Extension to diploma.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordDiplomaExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordDiplomaExtension', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordDiplomaExtension', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordDiplomaExtension', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The term for the session during the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordDiplomaExtension', @level2type=N'COLUMN', @level2name=N'TermDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year on which the student met  graduation requirements and was awarded a diploma.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordDiplomaExtension', @level2type=N'COLUMN', @level2name=N'DiplomaAwardDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of diploma/credential that is awarded to a student in recognition of his/her completion of the curricular requirements.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordDiplomaExtension', @level2type=N'COLUMN', @level2name=N'DiplomaTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3089. DistingLevelAchievementGraduate indicates the student has successfully completed the distinguished level of achievement as provided by TEC §28.025 (b-15) or TEC §28.0253.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordDiplomaExtension', @level2type=N'COLUMN', @level2name=N'DistingLevelAchievementGraduate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1724, C230. The FinancialAidApplication indicates the manner in which the student completed the graduation requirement of either completing a financial aid application (Free application for Federal Student Aid (FAFSA) or Texas Application for State Financial Aid (TASFA)) or submitting an exemption.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordDiplomaExtension', @level2type=N'COLUMN', @level2name=N'FinancialAidApplicationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1562. IndividualGraduationCommitteeGraduateIndicator Indicates whether a student for whom an IGC was established has graduated based on an IGC decision.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordDiplomaExtension', @level2type=N'COLUMN', @level2name=N'IndividualGraduationCommitteeGraduateIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1736, C233. TexasFirstEarlyHSCompletionProgram indicates the student graduated early under the Texas First Early High School Completion Program and specifies whether the student graduated two or more semesters or less than two semesters or equivalent earlier than the expected graduation date of the student''s high school cohort.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordDiplomaExtension', @level2type=N'COLUMN', @level2name=N'TexasFirstEarlyHSCompletionProgramDescriptorId'
GO

-- Extended Properties [tx].[StudentAcademicRecordEndorsementCompletedSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'TThe EndorsementCompletedSet common type represents the endorsements completed by a student and the date the student completed the endorsement. More than one EndorsementCompletedSet common type can be reported for a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordEndorsementCompletedSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordEndorsementCompletedSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordEndorsementCompletedSet', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordEndorsementCompletedSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The term for the session during the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordEndorsementCompletedSet', @level2type=N'COLUMN', @level2name=N'TermDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3124. CompletedDate is the first instructional day a student successfully completed a Foundation High School Program to earn a STEM, Business and Industry, Public Service, Arts and Humanities, or Multi-Disciplinary Studies endorsement.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordEndorsementCompletedSet', @level2type=N'COLUMN', @level2name=N'CompletedDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3021, C332. EndorsementCompleted indicates the student has successfully completed a Foundation High School Program to earn a STEM, Business and Industry, Public Services, Arts and Humanities, or Multi-Disciplinary Studies endorsement.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordEndorsementCompletedSet', @level2type=N'COLUMN', @level2name=N'EndorsementCompletedDescriptorId'
GO

-- Extended Properties [tx].[StudentAcademicRecordGraduationProgramParticipationSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The GraduationProgramParticipationSet common type represents a students graduation program participation.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSet', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The term for the session during the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSet', @level2type=N'COLUMN', @level2name=N'TermDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3029. FHSPDistingLevelParticipant indicates the student is currently pursuing the distinguished level of achievement under the Foundation High School Program as provided by TEC §28.025 (b-15).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSet', @level2type=N'COLUMN', @level2name=N'FHSPDistingLevelParticipant'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3030. FHSPParticipant indicates whether a student is currently pursuing the Foundation High School Program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSet', @level2type=N'COLUMN', @level2name=N'FHSPParticipant'
GO

-- Extended Properties [tx].[StudentAcademicRecordGraduationProgramParticipationSetEndorsementPursuing] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3022, C333. EndorsementPursuing indicates the student is pursuing a Foundation High School Program to earn a STEM, Business and Industry, Public Service, Arts and Humanities, or Multi-Disciplinary Studies endorsement.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSetEndorsementPursuing'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSetEndorsementPursuing', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSetEndorsementPursuing', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSetEndorsementPursuing', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The term for the session during the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSetEndorsementPursuing', @level2type=N'COLUMN', @level2name=N'TermDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3022, C333. EndorsementPursuing indicates the student is pursuing a Foundation High School Program to earn a STEM, Business and Industry, Public Service, Arts and Humanities, or Multi-Disciplinary Studies endorsement.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordGraduationProgramParticipationSetEndorsementPursuing', @level2type=N'COLUMN', @level2name=N'EndorsementPursuingDescriptorId'
GO

-- Extended Properties [tx].[StudentAcademicRecordIndividualGraduationCommitteeReviewSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The IndividualGraduationCommitteeReviewSet common type represents that an Individual Graduation Committee (IGC) has been established for a student and the date it was first established.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndividualGraduationCommitteeReviewSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndividualGraduationCommitteeReviewSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndividualGraduationCommitteeReviewSet', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndividualGraduationCommitteeReviewSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The term for the session during the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndividualGraduationCommitteeReviewSet', @level2type=N'COLUMN', @level2name=N'TermDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3122. EstablishedDate is the first instructional day an Individual Graduation Committee (IGC) has been established for a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndividualGraduationCommitteeReviewSet', @level2type=N'COLUMN', @level2name=N'EstablishedDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1563. IndividualGraduationCommitteeReview indicates whether an Individual Graduation Committee (IGC) has been established for a student regardless of which graduation program type is being pursued. This is collected for students in grades 11 and 12.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndividualGraduationCommitteeReviewSet', @level2type=N'COLUMN', @level2name=N'IndividualGraduationCommitteeReview'
GO

-- Extended Properties [tx].[StudentAcademicRecordIndustryBasedCertificationSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Common Type IndustryBasedCertificationSet.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndustryBasedCertificationSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The term for the session during the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'TermDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1632. DateCertTaken indicates the date upon which the industry based certification was taken.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'DateCertTaken'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1655, C226. IBCVendorCode identifies the organization or company that offered the service.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'IBCVendorDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1640, C214. PostSecondaryCertificationLicensure indicates a nationally or internationally recognized business or industry certification or license earned by a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'PostSecondaryCertificationLicensureDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1733, C232. PostSecondaryCertLicensureResult indicates the result of a state, nationally, or internationally recognized industry-based certification exam taken by a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'PostSecondaryCertLicensureResultDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3133. IBCBackgroundCheckCost identifies the amount of money that was paid for the background check (fingerprinting or criminal history record information reveiw) associated to an Industry-Based Certification passed/earned by a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'IBCBackgroundCheckCost'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1654. IBCExamFeeAmount identifies the amount of money that was paid for a student''s industry certification exam by the local education agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcademicRecordIndustryBasedCertificationSet', @level2type=N'COLUMN', @level2name=N'IBCExamFeeAmount'
GO

-- Extended Properties [tx].[StudentAcceleratedInstructionParticipationDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3085. StudentAcceleratedInstructionParticipation indicates whether or not the student participated in the prescribed accelerated instruction for the subject in which the student did not achieve satisfactory performance on an assessment instrument.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcceleratedInstructionParticipationDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAcceleratedInstructionParticipationDescriptor', @level2type=N'COLUMN', @level2name=N'StudentAcceleratedInstructionParticipationDescriptorId'
GO

-- Extended Properties [tx].[StudentApplication] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'DOCUMENTATION PENDING', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ApplicationIdentifier is a unique number or alphanumeric code assigned to an application.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'ApplicationIdentifier'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1093. The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3004. ApplicationDate is the month, day, and year the application was submitted.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'ApplicationDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3005, C327. ApplicationType indicates the type of application submitted.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'ApplicationTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The city the student was born in.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'BirthCity'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The country in which an individual is born. It is strongly recommended that entries use only ISO 3166 2-letter country codes.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'BirthCountryDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year on which an individual was born.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'BirthDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For students born outside of the U.S., the Province or jurisdiction in which an individual is born.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'BirthInternationalProvince'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A person''s gender at birth.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'BirthSexDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The abbreviation for the name of the state (within the United States) or extra-state jurisdiction in which an individual was born.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'BirthStateAbbreviationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For students born outside of the U.S., the date the student entered the U.S.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'DateEnteredUS'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1517, C050. The grade level or primary instructional level at which a student enters and receives services in a school or an educational institution during a given academic session.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'EntryGradeLevelDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A name given to an individual at birth, baptism, or during another naming ceremony, or through legal change.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'FirstName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0706, C012. GenerationCode identifies the generation suffix, if any, which the person attaches to his name.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'GenerationCodeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An appendage, if any, used to denote an individual''s generation in his family (e.g., Jr., Sr., III).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'GenerationCodeSuffix'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name borne in common by members of a family.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'LastSurname'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0923. LocalStudentId is the student''s local identification number as assigned by the local education agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'LocalStudentId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The individual''s maiden name.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'MaidenName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A secondary name given to an individual at birth, baptism, or during another naming ceremony.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'MiddleName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicator of whether the student was born with other siblings (i.e., twins, triplets, etc.)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'MultipleBirthStatus'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A prefix used to denote the title, degree, position, or seniority of the individual.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'PersonalTitlePrefix'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0004, C013. Sex is defined as a person''s gender.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'SexDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0001. StudentId is the student''s Social Security number or a state-approved alternative identification number.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'StudentId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1523. StudentUId (StudentUniqueId) is a unique number assigned to a student by the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplication', @level2type=N'COLUMN', @level2name=N'StudentUId'
GO

-- Extended Properties [tx].[StudentApplicationPersonalIdentificationDocument] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The documents presented as evident to verify one''s personal identity; for example: drivers license, passport, birth certificate, etc.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplicationPersonalIdentificationDocument'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ApplicationIdentifier is a unique number or alphanumeric code assigned to an application.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplicationPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'ApplicationIdentifier'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplicationPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1093. The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplicationPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The primary function of the document used for establishing identity.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplicationPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IdentificationDocumentUseDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The category of the document relative to its purpose.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplicationPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'PersonalInformationVerificationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The day when the document  expires, if null then never expires.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplicationPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'DocumentExpirationDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The title of the document given by the issuer.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplicationPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'DocumentTitle'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Country of origin of the document. It is strongly recommended that entries use only ISO 3166 2-letter country codes.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplicationPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IssuerCountryDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The unique identifier on the issuer''s identification system.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplicationPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IssuerDocumentIdentificationCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the entity or institution that issued the document.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentApplicationPersonalIdentificationDocument', @level2type=N'COLUMN', @level2name=N'IssuerName'
GO

-- Extended Properties [tx].[StudentAttributionDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor StudentAttribution is based on code table C161.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAttributionDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentAttributionDescriptor', @level2type=N'COLUMN', @level2name=N'StudentAttributionDescriptorId'
GO

-- Extended Properties [tx].[StudentCensusBlockGroupSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StudentCensusBlockGroup indicates the census block in which the student resides.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCensusBlockGroupSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCensusBlockGroupSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the StudentCensusBlockGroup', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCensusBlockGroupSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day an economically disadvantaged student was assigned to the Census Block Group Number.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCensusBlockGroupSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1648. StudentCensusBlockGroup indicates the census block in which the student resides.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCensusBlockGroupSet', @level2type=N'COLUMN', @level2name=N'StudentCensusBlockGroup'
GO

-- Extended Properties [tx].[StudentCrisisEventSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CommonType CrisisEvent indicates a state health or weather-related event that impacts a group of students, and may require additional funding, educational, or social services. The event may or may not cause the student to leave the district or campus of residence.  A crisis event is designated by the Commissioner of Education.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCrisisEventSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCrisisEventSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the CrisisEvent', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCrisisEventSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1054, C178. Descriptor CrisisEvent indicates a state health or weather-related event that impacts a group of students, and may require additional funding, educational, or social services. The event may or may not cause the student to leave the district or campus of residence.  A crisis event is designated by the Commissioner of Education.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCrisisEventSet', @level2type=N'COLUMN', @level2name=N'CrisisEventDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a student was assigned to the CrisisEvent descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCrisisEventSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[StudentCTEProgramAssociationCTEProgSVCSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The CTEProgSvcSet common type represents the student''s CTE program service information and the associated ServiceBeginDate and ServiceEndDate.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCTEProgramAssociationCTEProgSVCSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCTEProgramAssociationCTEProgSVCSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCTEProgramAssociationCTEProgSVCSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCTEProgramAssociationCTEProgSVCSet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCTEProgramAssociationCTEProgSVCSet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCTEProgramAssociationCTEProgSVCSet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCTEProgramAssociationCTEProgSVCSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3012, C064. CTEProgramSvc defines the services provided by an education organization to populations of students associated with a CTE program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCTEProgramAssociationCTEProgSVCSet', @level2type=N'COLUMN', @level2name=N'CTEProgramSvcDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3055. ServiceBeginDate is the first instructional day in the current school year a student is assigned to the CTEProgramSvc descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCTEProgramAssociationCTEProgSVCSet', @level2type=N'COLUMN', @level2name=N'ServiceBeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3056. EndDate is the first day after the last instructional day a student was eligible to receive Career and Technical Education services.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentCTEProgramAssociationCTEProgSVCSet', @level2type=N'COLUMN', @level2name=N'ServiceEndDate'
GO

-- Extended Properties [tx].[StudentDisciplineIncidentBehaviorAssociationExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentDisciplineIncidentBehaviorAssociationExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Describes behavior by category.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentDisciplineIncidentBehaviorAssociationExtension', @level2type=N'COLUMN', @level2name=N'BehaviorDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A locally assigned unique identifier (within the school or school district) to identify each specific DisciplineIncident or occurrence. The same identifier should be used to document the entire discipline incident even if it included multiple offenses and multiple offenders.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentDisciplineIncidentBehaviorAssociationExtension', @level2type=N'COLUMN', @level2name=N'IncidentIdentifier'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentDisciplineIncidentBehaviorAssociationExtension', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentDisciplineIncidentBehaviorAssociationExtension', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1734. SafeSupportiveSchoolProgramTeamReview indicates whether the Safe and Supportive School Program (SSSP) team conducted a threat assessment related to a reported disciplinary incident.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentDisciplineIncidentBehaviorAssociationExtension', @level2type=N'COLUMN', @level2name=N'SafeSupportiveSchoolProgramTeamReview'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationAcceleratedInstructionSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'AcceleratedInstructionSet.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAcceleratedInstructionSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAcceleratedInstructionSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAcceleratedInstructionSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3084, C352. AcceleratedInstructionSubject indicates the subject in which the student is eligible to receive accelerated instruction.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAcceleratedInstructionSet', @level2type=N'COLUMN', @level2name=N'AcceleratedInstructionSubjectDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3085, C353. StudentAcceleratedInstructionParticipation indicates whether or not the student participated in the prescribed accelerated instruction for the subject in which the student did not achieve satisfactory performance on an assessment instrument.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAcceleratedInstructionSet', @level2type=N'COLUMN', @level2name=N'StudentAcceleratedInstructionParticipationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3086. AssignedHoursAcceleratedInstruction indicates the number of hours of accelerated instruction assigned to the student for a particular subject.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAcceleratedInstructionSet', @level2type=N'COLUMN', @level2name=N'AssignedHoursAcceleratedInstruction'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3087. CompletedHoursAcceleratedInstruction indicates the number of hours of accelerated instruction the local education agency provided to the student in a particular subject.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAcceleratedInstructionSet', @level2type=N'COLUMN', @level2name=N'CompletedHoursAcceleratedInstruction'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3088, C354. DifferenceReasonHoursAcceleratedInstruction indicates the reason the student did not complete the full number of assigned hours of accelerated instruction.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAcceleratedInstructionSet', @level2type=N'COLUMN', @level2name=N'DifferenceReasonHoursAcceleratedInstructionDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3121. RatioWaiverListProductUsed indicates that the student received accelerated instruction through a product on the Ratio Waiver List for more than 50% of their required hours.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAcceleratedInstructionSet', @level2type=N'COLUMN', @level2name=N'RatioWaiverListProductUsed'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationAdultPreviousAttendanceSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The AdultPreviousAttendanceSet common type includes the set of data elements to identify if a student who is currently enrolled in a high school equivalency program, dropout recovery school, or other adult education program (under TEC §29.259), has or has not attended school in the previous nine months prior to enrolling.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAdultPreviousAttendanceSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAdultPreviousAttendanceSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAdultPreviousAttendanceSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1660, C362. AdultPreviousAttendance indicates whether an adult student (age 18-25) who is currently enrolled in a high school equivalency program, dropout recovery school, or other adult education program (under TEC §29.259), has or has not attended school in the previous nine months prior to enrolling.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAdultPreviousAttendanceSet', @level2type=N'COLUMN', @level2name=N'AdultPreviousAttendanceDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3010.  is the first instructional day a student is assigned to the AdultPreviousAttendance descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAdultPreviousAttendanceSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3020.  is the first day after the last instructional day a student was assigned to the AdultPreviousAttendance  descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationAdultPreviousAttendanceSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationDyslexiaRiskSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'DyslexiaRisk with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaRiskSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaRiskSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaRiskSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the DyslexiaRisk', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaRiskSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1644, C222. Descriptor DyslexiaRisk', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaRiskSet', @level2type=N'COLUMN', @level2name=N'DyslexiaRiskDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1732, C231. DyslexiaScreeningExceptionReason indicates the reason a student in kindergarten or first grade was not screened for dyslexia or related disorders during the dyslexia screening window.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaRiskSet', @level2type=N'COLUMN', @level2name=N'DyslexiaScreeningExceptionReasonDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a kindergarten or first grade student was assigned to the DyslexiaRisk descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaRiskSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationDyslexiaServicesSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'DyslexiaServicesSet with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaServicesSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaServicesSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaServicesSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the DyslexiaServices', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaServicesSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1650, C224. DyslexiaServices indicates the type of dyslexia or related service a student has received at any time during the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaServicesSet', @level2type=N'COLUMN', @level2name=N'DyslexiaServicesDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a student was assigned to the DyslexiaServices descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationDyslexiaServicesSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationEarlyReadingIndicatorSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EarlyReadingIndicator with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEarlyReadingIndicatorSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEarlyReadingIndicatorSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEarlyReadingIndicatorSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the EarlyReadingIndicator', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEarlyReadingIndicatorSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1522, C195. EarlyReadingIndicator indicates whether a student is eligible for accelerated reading instruction as indicated by the administered reading instrument.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEarlyReadingIndicatorSet', @level2type=N'COLUMN', @level2name=N'EarlyReadingIndicatorDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a kindergarten, first, or second-grade student was assigned to the EarlyReadingIndicator descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEarlyReadingIndicatorSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationEconomicDisadvantageSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EconomicDisadvantage with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEconomicDisadvantageSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEconomicDisadvantageSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEconomicDisadvantageSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the EconomicDisadvantage', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEconomicDisadvantageSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0785, C054. EconomicDisadvantage indicates the student''s economic disadvantage status.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEconomicDisadvantageSet', @level2type=N'COLUMN', @level2name=N'EconomicDisadvantageDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a student was assigned to the EconomicDisadvantage descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEconomicDisadvantageSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationEmergentBilingualSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EmergentBilingualSet with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEmergentBilingualSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEmergentBilingualSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEmergentBilingualSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the EmergentBilingualSet', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEmergentBilingualSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0790, C061. EmergentBilingualIndicator is an indication that the student has been identified as an emergent bilingual (EB) student by the Language Proficiency Assessment Committee (LPAC), or English proficient according to the criteria established in 19 TAC §89.1226.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEmergentBilingualSet', @level2type=N'COLUMN', @level2name=N'EmergentBilingualIndicatorDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a student was assigned to the EmergentBilingualIndicator descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationEmergentBilingualSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationExtension', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationExtension', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3083. StudentAcceleratedEducationPlan indicates a student did not perform satisfactorily on an assessment instrument under TEC §39.023(a) or §39.023(c) for two or more consecutive years in the same subject area and the school district developed an accelerated education plan as outlined in §28.0211(f).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationExtension', @level2type=N'COLUMN', @level2name=N'StudentAcceleratedEducationPlan'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationFosterCareTypeSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FosterCareType  with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFosterCareTypeSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFosterCareTypeSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFosterCareTypeSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the FosterCareType', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFosterCareTypeSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a student was assigned to the FosterCareType descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFosterCareTypeSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1528, C196. FosterCareType indicates whether a student is in the conservatorship of the Department of Family and Protective Services (DFPS) currently, or for a prekindergarten student that was previously in the conservatorship of DFPS, or for a prekindergarten student that is or ever has been in foster care in another state or territory, if the student resides in this state (Texas).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFosterCareTypeSet', @level2type=N'COLUMN', @level2name=N'FosterCareTypeDescriptorId'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationFullTimeHybridVirtualProgramParticipationSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The FullTimeHybridVirtualProgramParticipationSet common type indicates the type (hybrid or virtual) of program participation for a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFullTimeHybridVirtualProgramParticipationSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFullTimeHybridVirtualProgramParticipationSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFullTimeHybridVirtualProgramParticipationSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3010. BeginDate is the first instructional day a student is assigned to the FullTimeHybridVirtualProgramParticipation descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFullTimeHybridVirtualProgramParticipationSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3131, C363. FullTimeHybridVirtualProgramParticipation indicates the type (hybrid or virtual) of program participation for a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFullTimeHybridVirtualProgramParticipationSet', @level2type=N'COLUMN', @level2name=N'FullTimeHybridVirtualProgramParticipationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3020. EndDate is the first day after the last instructional day a student was assigned to the FullTimeHybridVirtualProgramParticpation descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationFullTimeHybridVirtualProgramParticipationSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationHomelessStatusSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HomelessStatus  with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationHomelessStatusSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationHomelessStatusSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationHomelessStatusSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the HomelessStatus', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationHomelessStatusSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a student was assigned to the HomelessStatus descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationHomelessStatusSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1082, C189. HomelessStatus as defined by 42 U.S.C. Section Part B §11434(a), definitions the term “homeless children and youths” —
(A) means individuals who lack a fixed, regular, and adequate nighttime residence [within the meaning of section 11302(a)(1)]; and
(B) the term includes —
(i) children and youths who are sharing the housing of other persons due to loss of housing, economic hardship, or a similar reason; are living in motels, hotels, trailer parks, or camping grounds due to the lack of alternative adequate accommodations; are living in emergency or transitional shelters
(ii) children and youths who have a primary nighttime residence that is a public or private place not designed for or ordinarily used as a regular sleeping accommodation for human beings [within the meaning of section 11302(a)(2)(C)];
(iii) children and youths who are living in cars, parks, public spaces, abandoned buildings, substandard housing, bus or train stations, or similar settings; and
(iv) migratory children (as such term is defined in section 6399 of title 20) who qualify as homeless for the purposes of this subtitle because the children are living in circumstances described in clauses (i) through (iii).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationHomelessStatusSet', @level2type=N'COLUMN', @level2name=N'HomelessStatusDescriptorId'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationMilitaryConnectedStudentSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'MilitaryConnectedStudentIndicator with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationMilitaryConnectedStudentSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationMilitaryConnectedStudentSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationMilitaryConnectedStudentSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for MilitaryConnectedStudent', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationMilitaryConnectedStudentSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a student was assigned to the MilitaryConnectedStudent descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationMilitaryConnectedStudentSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1529, C197. MilitaryConnectedStudent indicates a student enrolled in a school district or open-enrollment charter school who is a dependent of an active duty or former member of the United States military, the Texas National Guard, or a reserve force of the United States military, or who is a dependent of a member of the United States military, the Texas National Guard, or a reserve force of the United States military who was killed in the line of duty.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationMilitaryConnectedStudentSet', @level2type=N'COLUMN', @level2name=N'MilitaryConnectedStudentDescriptorId'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationPKFundingSourceSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PKFundingSource with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKFundingSourceSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKFundingSourceSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKFundingSourceSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effective date for the PKFundingSource', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKFundingSourceSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3040. The OrderOfPKFundingSource is the order of the student''s PK Funding Source:1 - Primary 2 - Secondary', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKFundingSourceSet', @level2type=N'COLUMN', @level2name=N'OrderOfPKFundingSource'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a prekindergarten student was identified as being funded by the specific source.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKFundingSourceSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3044, C186. PKFundingSource indicates the source of funding for a prekindergarten student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKFundingSourceSet', @level2type=N'COLUMN', @level2name=N'PKFundingSourceDescriptorId'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationPKProgramTypeSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PKProgramType with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKProgramTypeSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKProgramTypeSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKProgramTypeSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the PKProgramType', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKProgramTypeSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1078, C185. PKProgramType indicates the length of the Prekindergarten instructional day for a particular Prekindergarten student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKProgramTypeSet', @level2type=N'COLUMN', @level2name=N'PKProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a prekindergarten student was assigned to the PKProgramType descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationPKProgramTypeSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationTruancySet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'TruancySet represents truancy data associated to students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationTruancySet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationTruancySet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationTruancySet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3014. DateMet is the month, day and year when any of the following occurs:
1. A student who is required to attend school under TEC §25.085, and are not exempted under TEC §25.086, and fail to attend school without excuse for 10 or more days within a six-month period of a school year.
2. The local education agency initiated a truancy prevention measure under TEC §25.0915 (a-4) for the student.
3. Indicates whether an attendance officer or other school official has filed a complaint against a student''s parent or legal guardian under TEC §25.093.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationTruancySet', @level2type=N'COLUMN', @level2name=N'DateMet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3068, C346. Truancy captures the truancy data associated to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationTruancySet', @level2type=N'COLUMN', @level2name=N'TruancyDescriptorId'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationUnaccompaniedYouthSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UnaccompaniedYouthStatus with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnaccompaniedYouthSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnaccompaniedYouthSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnaccompaniedYouthSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for the UnaccompaniedYouth', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnaccompaniedYouthSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a student was assigned to the UnaccompaniedYouth descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnaccompaniedYouthSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1084, C192. UnaccompaniedYouth, as defined by 42 U.S.C. Section Part B §11434(a), the term “unaccompanied youth” — includes a homeless child in the physical custody of a parent or guardian.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnaccompaniedYouthSet', @level2type=N'COLUMN', @level2name=N'UnaccompaniedYouthDescriptorId'
GO

-- Extended Properties [tx].[StudentEducationOrganizationAssociationUnschooledAsyleeRefugeeSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UnschooledAsyleeRefugee with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnschooledAsyleeRefugeeSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnschooledAsyleeRefugeeSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnschooledAsyleeRefugeeSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Begin date of the effecive date for UnschooledAsyleeRefugee', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnschooledAsyleeRefugeeSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EndDate is the first day after the last instructional day a student was assigned to the UnschooledAsyleeRefugee descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnschooledAsyleeRefugeeSet', @level2type=N'COLUMN', @level2name=N'EndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1076, C183. As defined by NCLB, Title X, Part C, Section 725(6), the term “unaccompanied youth” means a youth not in the physical custody of a parent or guardian.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentEducationOrganizationAssociationUnschooledAsyleeRefugeeSet', @level2type=N'COLUMN', @level2name=N'UnschooledAsyleeRefugeeDescriptorId'
GO

-- Extended Properties [tx].[StudentExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentExtension', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3006, C323. AsOfStatusLastDayEnrollment indicates the student''s status in the district on the last day of school or last date of enrollment in the current school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentExtension', @level2type=N'COLUMN', @level2name=N'AsOfStatusLastDayEnrollmentDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3007, C324. AsOfStatusLastFridayOctober indicates the student''s status in the local education agency on the last Friday in October in the current school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentExtension', @level2type=N'COLUMN', @level2name=N'AsOfStatusLastFridayOctoberDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0706, C012. GenerationCode identifies the generation suffix, if any, which the person attaches to his name.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentExtension', @level2type=N'COLUMN', @level2name=N'GenerationCodeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0923. LocalStudentId is the student''s local identification number as assigned by the local education agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentExtension', @level2type=N'COLUMN', @level2name=N'LocalStudentId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3009. StudentDoNotReportTSDS indicates the student should not be reported for TSDS state or federal data collections.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentExtension', @level2type=N'COLUMN', @level2name=N'StudentDoNotReportTSDS'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0001. StudentId is the student''s Social Security number or a state-approved alternative identification number.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentExtension', @level2type=N'COLUMN', @level2name=N'StudentId'
GO

-- Extended Properties [tx].[StudentLanguageInstructionProgramAssociationLangInstruProgramSvcSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The LangInstruProgramSvcSet common type captures the service(s) being provided to the student by the language instruction program and the ServiceBeginDate and ServiceEndDate associated with the LanguageInstructionProgramService data element.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationLangInstruProgramSvcSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationLangInstruProgramSvcSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationLangInstruProgramSvcSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationLangInstruProgramSvcSet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationLangInstruProgramSvcSet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationLangInstruProgramSvcSet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationLangInstruProgramSvcSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3034, C335. The LangInstruProgramSvc defines the services provided by an education organization to populations of students associated with a language instruction program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationLangInstruProgramSvcSet', @level2type=N'COLUMN', @level2name=N'LangInstruProgramSvcDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3055. ServiceBeginDate is the first instructional day a student is assigned to the LangInstruProgramSvc descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationLangInstruProgramSvcSet', @level2type=N'COLUMN', @level2name=N'ServiceBeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3056. ServiceEndDate is the first day after the last instructional day a student is no longer assigned to the LangInstruProgramSvc descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationLangInstruProgramSvcSet', @level2type=N'COLUMN', @level2name=N'ServiceEndDate'
GO

-- Extended Properties [tx].[StudentLanguageInstructionProgramAssociationParentalPermissionSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ParentalPermissionSet with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationParentalPermissionSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationParentalPermissionSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationParentalPermissionSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationParentalPermissionSet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationParentalPermissionSet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationParentalPermissionSet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationParentalPermissionSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3042. ParentalPermissionSetBeginDate indicates the month, day, and year when the student''s parent or legal guardian has approved placement of the student in the required bilingual or English as a Second Language (ESL) program. (See 19 TAC §89.1240.)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationParentalPermissionSet', @level2type=N'COLUMN', @level2name=N'ParentalPermissionSetBeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0896, C093. ParentalPermission indicates whether the student''s parent or legal guardian has approved placement of the student in the required bilingual or English as a Second Language (ESL) program or if the parent of a non-EB student has requested placement in a program. (See 19 TAC §89.1240.)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationParentalPermissionSet', @level2type=N'COLUMN', @level2name=N'ParentalPermissionDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3043. ParentalPermissionSetEndDate is the first day after the last instructional day a student was assigned to the ParentalPermission descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentLanguageInstructionProgramAssociationParentalPermissionSet', @level2type=N'COLUMN', @level2name=N'ParentalPermissionSetEndDate'
GO

-- Extended Properties [tx].[StudentNonEnrolledStudentUILActivity] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1739. NonEnrolledStudentUILActivity indicates the University Interscholastic League (UIL) activity in which a non-enrolled student participated at a school district that allows participation of non-enrolled students under Section 33.0832.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentNonEnrolledStudentUILActivity'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentNonEnrolledStudentUILActivity', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1739. NonEnrolledStudentUILActivity indicates the University Interscholastic League (UIL) activity in which a non-enrolled student participated at a school district that allows participation of non-enrolled students under Section 33.0832.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentNonEnrolledStudentUILActivity', @level2type=N'COLUMN', @level2name=N'NonEnrolledStudentUILActivityDescriptorId'
GO

-- Extended Properties [tx].[StudentProgramAttendanceEventExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentProgramAttendanceEventExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A code describing the attendance event, for example:
        Present
        Unexcused absence
        Excused absence
        Tardy.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentProgramAttendanceEventExtension', @level2type=N'COLUMN', @level2name=N'AttendanceEventCategoryDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentProgramAttendanceEventExtension', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date for this attendance event.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentProgramAttendanceEventExtension', @level2type=N'COLUMN', @level2name=N'EventDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentProgramAttendanceEventExtension', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentProgramAttendanceEventExtension', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentProgramAttendanceEventExtension', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentProgramAttendanceEventExtension', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0173, C035. InstructionalSetting identifies the setting used in providing instruction to students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentProgramAttendanceEventExtension', @level2type=N'COLUMN', @level2name=N'InstructionalSettingDescriptorId'
GO

-- Extended Properties [tx].[StudentSchoolAssociationExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSchoolAssociationExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The month, day, and year on which an individual enters and begins to receive instructional services in a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSchoolAssociationExtension', @level2type=N'COLUMN', @level2name=N'EntryDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSchoolAssociationExtension', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSchoolAssociationExtension', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0787, C059. ADAEligibility indicates the eligibility status of the student as reflected in the attendance accounting records of the district.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSchoolAssociationExtension', @level2type=N'COLUMN', @level2name=N'ADAEligibilityDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1027. CampusIdOfAccountability indicates the unique campus identification number to which a student’s attendance and/or leaver accountability data are attributed for campus accountability purposes.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSchoolAssociationExtension', @level2type=N'COLUMN', @level2name=N'CampusIdOfAccountability'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0903. CampusIdOfResidence indicates the unique campus identification number corresponding to the campus attendance area in which the student currently resides.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSchoolAssociationExtension', @level2type=N'COLUMN', @level2name=N'CampusIdOfResidence'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3080, C351. The EnrollmentTrackingVerification indicates the status of the enrollment event.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSchoolAssociationExtension', @level2type=N'COLUMN', @level2name=N'EnrollmentTrackingVerificationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1000, C161. StudentAttribution is a characteristic of a student relating to their individual enrollment circumstances.  It indicates whether the student:
- attends an open enrollment charter school;
- is served in a juvenile justice alternative education program (JJAEP);
- attends school in the district through a Public Education Grant (PEG);
- attends school by means of a transfer between LEAs;
- attends school in the district, lives outside the boundaries of the state of Texas, and therefore is not an inter district transfer;
- lives in Texas but outside district boundaries and is served in a juvenile pre-adjudication secure detention facility or a juvenile post-adjudication secure correctional facility;
- lives in Texas but outside district boundaries and is served in a residential treatment center;
- is served by the Texas School for the Deaf as a parent referral;
- is enrolled in South Texas ISD (031-916);
- is a student with a disability enrolled by their parent(s) in a private school (including a home school) but who receives special education and/or related services from the public school district under an individualized services plan (ISP);
- is a child of a charter school employee (LEA or Campus); or
- student-initiated transfer due to remote learning.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSchoolAssociationExtension', @level2type=N'COLUMN', @level2name=N'StudentAttributionDescriptorId'
GO

-- Extended Properties [tx].[StudentSectionAssociationExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSectionAssociationExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Month, day, and year of the student''s entry or assignment to the section.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The local code assigned by the School that identifies the course offering provided for the instruction of students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'LocalCourseCode'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to a school.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'SchoolId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'SchoolYear'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The local identifier assigned to a section.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'SectionIdentifier'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier for the calendar for the academic session.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'SessionName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1068. CourseCompletionIndicator indicates whether or not the student finished the full sequence of instruction for a course.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSectionAssociationExtension', @level2type=N'COLUMN', @level2name=N'CourseCompletionIndicator'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationAssessment] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Assessment represents the assessments conducted to evaluate a student''s language acquisition.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationAssessment'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationAssessment', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationAssessment', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationAssessment', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationAssessment', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationAssessment', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationAssessment', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1668, C320. ToolOrAssessmentUsed identifies the tool or assessment used to assess the student’s language acquisition.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationAssessment', @level2type=N'COLUMN', @level2name=N'ToolOrAssessmentUsedDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1669, C321. AssessmentResultsObtained identifies the result of tools or assessments used to assess the student’s language acquisition.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationAssessment', @level2type=N'COLUMN', @level2name=N'AssessmentResultsObtainedDescriptorId'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationDisabilitySet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'DisabilitySet', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A disability category that describes a individual''s impairment.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet', @level2type=N'COLUMN', @level2name=N'DisabilityDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3016. DisabilitySetBeginDate indicates the month, day, and year the order of the disability becomes true.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet', @level2type=N'COLUMN', @level2name=N'DisabilitySetBeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3017. DisabilitySetEndDate indicates the month, day, and year the order of the disability becomes false.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet', @level2type=N'COLUMN', @level2name=N'DisabilitySetEndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'EligibilityDateDisabilities indicates the date upon which a student who is deaf or hard of hearing is eligible for services.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet', @level2type=N'COLUMN', @level2name=N'EligibilityDateDisabilities'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3039. The OrderOfDisability is the order by severity of student''s disabilities:1. Primary 2. Secondary 3 Tertiary', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationDisabilitySet', @level2type=N'COLUMN', @level2name=N'OrderOfDisability'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationExtension] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationExtension'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationExtension', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationExtension', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationExtension', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationExtension', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationExtension', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationExtension', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1661, C313. PreferredHomeCommunicationMethod identifies the preferred unique communication method used by the child at home.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationExtension', @level2type=N'COLUMN', @level2name=N'PreferredHomeCommunicationMethodDescriptorId'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationHearingAmplification] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HearingAmplification represents the hearing amplification device(s), access and use for a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationHearingAmplification'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationHearingAmplification', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationHearingAmplification', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationHearingAmplification', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationHearingAmplification', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationHearingAmplification', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationHearingAmplification', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1665, C317. HearingAmplificationType identifies the type of hearing amplification device used by the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationHearingAmplification', @level2type=N'COLUMN', @level2name=N'HearingAmplificationTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1666, C318. HearingAmplificationAccess identifies whether the student has access to the hearing amplification device for the full-day or partial day for each HEARING-AMPLIFICATION-TYPE reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationHearingAmplification', @level2type=N'COLUMN', @level2name=N'HearingAmplificationAccessDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1667, C319. HearingAmplificationDailyUse identifies the average amount of time the hearing amplification device is used in a day based on the HEARING-AMPLIFICATION-ACCESS reported.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationHearingAmplification', @level2type=N'COLUMN', @level2name=N'HearingAmplificationDailyUseDescriptorId'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationInstructionalSettingSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'InstructionalSettingSet represents the InstructionalSetting with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationInstructionalSettingSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationInstructionalSettingSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationInstructionalSettingSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationInstructionalSettingSet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationInstructionalSettingSet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationInstructionalSettingSet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationInstructionalSettingSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3025. InstructionalSettingBeginDate is the first instructional day a student is assigned to the InstructionalSetting descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationInstructionalSettingSet', @level2type=N'COLUMN', @level2name=N'InstructionalSettingBeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0173, C035. InstructionalSetting identifies the setting used in providing instruction to students.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationInstructionalSettingSet', @level2type=N'COLUMN', @level2name=N'InstructionalSettingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3026. InstructionalSettingEndDate is the first day after the last instructional day a student was assigned to the InstructionalSetting descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationInstructionalSettingSet', @level2type=N'COLUMN', @level2name=N'InstructionalSettingEndDate'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationLanguageAcquisition] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'LanguageAcquisition represents the language acquisition services a student has received.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationLanguageAcquisition'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationLanguageAcquisition', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationLanguageAcquisition', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationLanguageAcquisition', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationLanguageAcquisition', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationLanguageAcquisition', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationLanguageAcquisition', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1662, C314. LangAcqServicesProvided indicates the specific language acquisition services provided to the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationLanguageAcquisition', @level2type=N'COLUMN', @level2name=N'LangAcqServicesProvidedDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1663, C315. FrequencyOfServices identifies the frequency with which a student receives services.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationLanguageAcquisition', @level2type=N'COLUMN', @level2name=N'FrequencyOfServicesDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1664, C316. HoursSpentReceivingServices identifies the amount of time in which the student receives services.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationLanguageAcquisition', @level2type=N'COLUMN', @level2name=N'HoursSpentReceivingServicesDescriptorId'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationSPEDProgramSvcSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The SPEDProgramSvcSet common type captures the type of special education program services that a student participates in or receives services from and the ServiceBeginDate and ServiceEndDate associated with the SPEDProgramSvc data element.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationSPEDProgramSvcSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationSPEDProgramSvcSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationSPEDProgramSvcSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationSPEDProgramSvcSet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationSPEDProgramSvcSet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationSPEDProgramSvcSet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationSPEDProgramSvcSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3055. ServiceBeginDate is the first instructional day a student is assigned to the SPEDProgramSvc descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationSPEDProgramSvcSet', @level2type=N'COLUMN', @level2name=N'ServiceBeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3058, C341. SPEDProgramSvc defines the services provided by an education organization to populations of students associated with a special education program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationSPEDProgramSvcSet', @level2type=N'COLUMN', @level2name=N'SPEDProgramSvcDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3056. ServiceEndDate  is the first day after the last instructional day a student is no longer assigned to the SPEDProgramSvc descriptor.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationSPEDProgramSvcSet', @level2type=N'COLUMN', @level2name=N'ServiceEndDate'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesEntrySet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The StudentEarlyChildhoodOutcomesEntrySet captures the rating information for SPPI-7 when a student enters the Early Childhood Special Education (ECSE) program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesEntrySet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesEntrySet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesEntrySet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesEntrySet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesEntrySet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesEntrySet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesEntrySet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3102, C357. ECSEEntryAppropriateFunctioningSkillsRating indicates the student''s level of functioning in the use of appropriate behaviors to meet their needs upon entry into the early childhood special education (ECSE) program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesEntrySet', @level2type=N'COLUMN', @level2name=N'ECSEAppropriateFunctioningEntrySkillsRatingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3101, C357. ECSEEntryKnowledgeSkillsRating indicates the student''s level of functioning in the acquisition and use of knowledge and skills (including early language/communication) upon entry into the early childhood special education (ECSE) program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesEntrySet', @level2type=N'COLUMN', @level2name=N'ECSEKnowledgeEntrySkillsRatingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3100, C357. ECSEEntrySocialEmotionalSkillsRating indicates the student''s level of functioning in positive social-emotional skills (including social relationships) upon entry into the early childhood special education (ECSE) program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesEntrySet', @level2type=N'COLUMN', @level2name=N'ECSESocialEmotionalEntrySkillsRatingDescriptorId'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The StudentEarlyChildhoodOutcomesExitSet captures the rating information for SPPI-7 when a student exits the Early Childhood Special Education (ECSE) program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3108, C359. ECSEAppropriateFunctioningExitSkillsRating indicates the student''s level of functioning in the use of appropriate behaviors to meet their needs upon exit from the early childhood special education (ECSE) program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'ECSEAppropriateFunctioningExitSkillsRatingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3109. ECSEExitAppropriateFunctioningNewSkills indicates if the child has shown any new skills or behaviors related to taking appropriate action to meet needs since the local education agency’s initial skills rating (child outcomes summary).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'ECSEExitAppropriateFunctioningNewSkills'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3107. ECSEExitKnowledgeNewSkills indicates if the child has shown any new skills or behaviors related to acquiring and using knowledge and skills since the local education agency’s initial skills rating (child outcomes summary).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'ECSEExitKnowledgeNewSkills'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3105. ECSEExitSocialEmotionalNewSkills indicates if the child has shown any new skills or behaviors related to positive social-emotional skills (including positive social relationships) since the local education agency’s initial skills rating (child outcomes summary).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'ECSEExitSocialEmotionalNewSkills'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3106, C359. ECSEKnowledgeExitSkillsRating indicates the student''s level of functioning in the acquisition and use of knowledge and skills (including early language/communication) upon exit from the early childhood special education (ECSE) program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'ECSEKnowledgeExitSkillsRatingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3103, C358. ECSEServiceExitReason indicaes the reason a student exited from a local education agency''s (LEA''s) early childhood special education (ECSE) Program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'ECSEServiceExitReasonDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3104, C359. ECSESocialEmotionalExitSkillsRating indicates the student''s level of functioning in positive social-emotional skills (including social relationships) upon exit from the early childhood special education (ECSE) program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentEarlyChildhoodOutcomesExitSet', @level2type=N'COLUMN', @level2name=N'ECSESocialEmotionalExitSkillsRatingDescriptorId'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociation] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StudentResidentialFacilityAssociation captures enrollment data for students enrolled at a residential facility during a particular school year.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociation'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociation', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociation', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociation', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociation', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociation', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociation', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1630. DateEnteredRF indicates the date the student enters the residential facility.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociation', @level2type=N'COLUMN', @level2name=N'DateEnteredRF'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1627. ResidentialFacilityId indicates the unique residential facility identification number registered with the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociation', @level2type=N'COLUMN', @level2name=N'ResidentialFacilityId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1631. DateExitedRF indicates the date the student exits the residential facility.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociation', @level2type=N'COLUMN', @level2name=N'DateExitedRF'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3064,E3065,E1633,E1634,E1635,E1636,E1637,E1638. Student residential facility being used', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1630. DateEnteredRF indicates the date the student enters the residential facility.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'DateEnteredRF'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1627. ResidentialFacilityId indicates the unique residential facility identification number registered with the Texas Education Agency.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'ResidentialFacilityId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3064. StudentResFacAssocSetBeginDate indicates the first month, day, and year any data element in the StudentResFacAssocSet common type becomes true for the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'StudentResFacAssocSetBeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1633. AttendanceZoneCampus is the nine-digit identifying number (assigned by the TEA) of the campus the student is expected to attend based on the geographic location (address) of the residential facility in which the student resides. This may or may not be the same as the “SchoolId.”', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'AttendanceZoneCampus'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1638. CampusIDOfEnrollmentSchoolDayLength indicates the number of instructional minutes in a school day for a non-disabled peer at the SchoolID of enrollment.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'CampusIdOfEnrollmentSchoolDayLength'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1634. EducatedAtResidentialFacility indicates whether a student is educated at or in the general location of a residential facility.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'EducatedAtResidentialFacility'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1636. NumberOtherStudentsAssignedSameSurrogateParent indicates how many other students have been assigned to the same surrogate parent.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'NumberOtherStudentsAssignedSameSurrogateParent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1637. ResidentialFacilityStudentSchoolDayLength indicates the number of minutes the residential facility student receives instruction based on the Individualized Education Program (IEP).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'ResidentialFacilityStudentSchoolDayLength'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3065. StudentResFacAssocSetEndDate is the first day after the last instructional day any data element in the StudentResFasAssocSet common type changes or becomes false for the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'StudentResFacAssocSetEndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1635. SurrogateParentAssigned indicates whether the student has been assigned a surrogate parent.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentResidentialFacilityAssociationStudentResFacAssocSet', @level2type=N'COLUMN', @level2name=N'SurrogateParentAssigned'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The StudentSecondaryTransitionSet captures the information for SPPI-13.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3118, C360. ARDInvitedRepresentative indicates whether or not there is evidence that a representative of any participating agency was invited to the Admission, Review, and Dismissal (ARD) Committee meeting with the prior consent of the parent or student who has reached age of majority.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'ARDInvitedRepresentativeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3117. ARDInvitedStudent indicates whether or not there is documented evidence the student was invited to the Admission, Review, and Dismissal (ARD) Committee meeting where transition services were discussed.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'ARDInvitedStudent'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3115. CoursesStudySecondaryGoals indicates whether or not the transition services included courses of study that will reasonably enable the student to meet their postsecondary goals.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'CoursesStudySecondaryGoals'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3114. IEPTransitionServices indicates whether or not the student''s individualized education program (IEP) includes transition services that will reasonably enable the student to meet their postsecondary goals.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'IEPTransitionServices'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3111. MeasurableSecondaryGoals indicates whether or not there were appropriate measurable postsecondary goals in the areas of training, education, employment, and, where appropriate, independent living skills in a student’s individualized education program (IEP).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'MeasurableSecondaryGoals'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3110. SecondaryTransitionARDMeetingDate is the most recent date the admission, review, and dismissal (ARD) committee met to update a student’s individualized education program (IEP) to include:

appropriate measurable postsecondary goals that are annually updated and based upon an age-appropriate transition assessment,
transition services, including courses of study, that will reasonably enable the student to meet those postsecondary goals, and
annual IEP goals related to the student’s transition service needs.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'SecondaryTransitionARDMeetingDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3099. SecondaryTransitionIEPReviewDate is the date the Local Education Agency (LEA) reviewed the student''s individualized education program (IEP) folder for documentation of the SPPI-13 indicator requirements.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'SecondaryTransitionIEPReviewDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3113. TransitionAssessment indicates whether or not there is evidence that the measurable postsecondary goals were based on age-appropriate transition assessments.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'TransitionAssessment'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3116. TransitionServiceNeeds indicates whether or not the there is/are annual individualized education program (IEP) goals related to the student’s transition service needs.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'TransitionServiceNeeds'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3112. UpdatedSecondaryGoals indicates whether or not the postsecondary goals set in the individualized education program (IEP) were updated annually.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSecondaryTransitionSet', @level2type=N'COLUMN', @level2name=N'UpdatedSecondaryGoals'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StudentSPEDProgramAssociationSet representshe MedicallyFragile, MultiplyDisabled, LEAOfRDSPDService, ChildCountFunding, PPCDServiceLocation with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3047. ProgramBeginDate indicates the month, day, and year the student special education program association set becomes true of the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'ProgramBeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0832, C066. ChildCountFunding indicates under which federal program the student receiving special education and related services is counted.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'ChildCountFundingDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1077, C184. ECSEServiceLocation indicates whether or not the Early Childhood Special Education (ECSE) student received their early childhood special education services in a regular early childhood program, which is defined as a program that is designed for typically developing children ages three through five (not in kindergarten) and is not specifically or primarily designed for children with disabilities and includes (at the time of the placement decision) a majority of at least 50 percent of nondisabled children (i.e., children without an individualized education program (IEP)).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'ECSEServiceLocationDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1527. LEAOfRDSPDService indicates the RDSPD Fiscal Agent district that provides the RDSPD service to a particular RDSPD student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'LEAOfRDSPDService'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0999. MedicallyFragile indicates whether the student receiving special education and related services is: 1) in the age range of birth to 22 years, and 2) has a serious, ongoing illness or a chronic condition that has lasted or is anticipated to last at least 12 or more months or has required at least one month of hospitalization, and that requires daily, ongoing medical treatments and monitoring by appropriately trained personnel which may include parents or other family members, and 3) requires the routine use of medical device or of assistive technology to compensate for the loss of usefulness of a body function needed to participate in activities of daily living, and4) lives with ongoing threat to his or her continued well-being.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'MedicallyFragile'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0882. MultiplyDisabled indicates whether the student receiving special education and related services has been designated as multiply disabled by the admission, review, and dismissal committee.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'MultiplyDisabled'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3048. ProgramEndDate is the first day after the last instructional day any data element in the StudentSpecialEducationProgramAssociationSet common type changes or becomes false for the student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramAssociationStudentSPEDProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'ProgramEndDate'
GO

-- Extended Properties [tx].[StudentSpecialEducationProgramEligibilityAssociation] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is the Child Find collection. Child Find combines State Performance Plan Indicator 11 (SPPI-11) and State Performance Plan Indicator 12 (SPPI-12) in the TSDS Core Collection. SPPI-11 refers to the timely evaluation of students, ages 3-21, for special education services under Part B of IDEA. SPPI-12 refers to children who are referred from Part C of IDEA prior to age 3, found eligible for Part B of IDEA, and have an individualized education plan (IEP) developed and implemented by their third birthday to receive early childhood special education (ECSE) services from a local education agency (LEA).', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1738. ConsentToEvaluationReceivedDate is the month, day, and year the Local Education Agency (LEA) received written consent for the full individual and initial evaluation (FIIE) from the student’s parent.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'ConsentToEvaluationReceivedDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1731, C347. EligibilityDelayReason refers to the reason why the eligibility determination was completed beyond the required timeframe.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'EligibilityDelayReasonDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1716. EligibilityDeterminationDate indicates the month, day, and year the LEA held the admission, review, and dismissal (ARD) committee meeting regarding the child’s initial eligibility determination for special education and related services. An Individualized Education Program (IEP) would be developed and implemented for a child admitted into special education on this same date.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'EligibilityDeterminationDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1715. EligibilityEvaluationDate indicates the month, day, and year when the written full individual and initial evaluation (FIIE) report was completed.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'EligibilityEvaluationDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1711. EvaluationDelayDays indicates the number of student absences, if any, beginning the first instructional day following the date on which the Local Education Agency (LEA) received written parental consent for the full individual and initial evaluation (FIIE) report.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'EvaluationDelayDays'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1718, C348. EvaluationDelayReason refers to the justification as to why the written full individual and initial evaluation (FIIE) report was completed beyond the State-established 45 instructional day timeframe for state performance plan indicator 11 (SPPI-11), or the justification as to why a child who was receiving early childhood intervention (ECI) services had their eligibility for early childhood special education (ECSE) determined beyond the child’s third birthday for SPPI-12.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'EvaluationDelayReasonDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1717. IDEAIndicator indicates whether or not the student was determined eligible and enrolled in special education and related services as a result of the full individual and initial evaluation (FIIE) report and the admission, review, and dismissal (ARD) committee meeting decision.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'IDEAIndicator'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1737. OriginalECIServicesDate is the month, date, and year when an infant or toddler, from birth through age 2, began participating in the early childhood intervention program. (See Texas Human Resources Code §73.001 and 73.021)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'OriginalECIServicesDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1713. TransitionConferenceDate indicates the month, day, and year when the transition conference was held (for a child receiving early childhood intervention (ECI) services) among the lead agency, the family, and the LEA where the child resides to discuss the child’s potential eligibility for early childhood special education (ECSE) services.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'TransitionConferenceDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E1712. TransitionNotificationDate indicates the month, day, and year the LEA Notification of Potentially Eligible for Special Education Services was sent by the early childhood intervention (ECI) contractor to the local education agency (LEA) to notify them that a child enrolled in ECI will shortly reach the age of eligibility for Part B services and the child is potentially eligible for services under Part B, early childhood special education (ECSE).  The LEA Notification constitutes a referral to the LEA for an initial evaluation and eligibility determination of the child which the parent may opt out from the referral.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentSpecialEducationProgramEligibilityAssociation', @level2type=N'COLUMN', @level2name=N'TransitionNotificationDate'
GO

-- Extended Properties [tx].[StudentTitleIPartAProgramAssociationSet] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StudentTitleIPartAProgramAssociationSet with effective dates.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentTitleIPartAProgramAssociationSet'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The earliest date the student is involved with the program. Typically, this is the date the student becomes eligible for the program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentTitleIPartAProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'BeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentTitleIPartAProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'EducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier assigned to an education organization.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentTitleIPartAProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'ProgramEducationOrganizationId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The formal name of the program of instruction, training, services, or benefits available through federal, state, or local agencies.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentTitleIPartAProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'ProgramName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentTitleIPartAProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'ProgramTypeDescriptorId'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique alphanumeric code assigned to a student.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentTitleIPartAProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'StudentUSI'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3066. StudentTitleIPartAProgramAssociationBeginDate indicates the month, day, and year the student began participating in a Title I Part A program.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentTitleIPartAProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'StudentTitleIPartAProgramAssociationSetBeginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E3067. StudentTitleIPartAProgramAssociationSetEndDate is the first day after the last instructional day a student was eligible to receive Title I Part A services.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentTitleIPartAProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'StudentTitleIPartAProgramAssociationSetEndDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'E0894, C122. An indication of the type of Title I program, if any, in which the student is participating and by which the student is served.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'StudentTitleIPartAProgramAssociationSet', @level2type=N'COLUMN', @level2name=N'TitleIPartAParticipantDescriptorId'
GO

-- Extended Properties [tx].[TeacherIncentiveAllotmentDesignationDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor TeacherIncentiveAllotmentDesignation is based on code table C322', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'TeacherIncentiveAllotmentDesignationDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'TeacherIncentiveAllotmentDesignationDescriptor', @level2type=N'COLUMN', @level2name=N'TeacherIncentiveAllotmentDesignationDescriptorId'
GO

-- Extended Properties [tx].[TexasFirstEarlyHSCompletionProgramDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor TexasFirstEarlyHSCompletionProgram is based on code table C233.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'TexasFirstEarlyHSCompletionProgramDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'TexasFirstEarlyHSCompletionProgramDescriptor', @level2type=N'COLUMN', @level2name=N'TexasFirstEarlyHSCompletionProgramDescriptorId'
GO

-- Extended Properties [tx].[TitleOfAssessmentDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor TitleOfAssessment is populated from Code Table C312.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'TitleOfAssessmentDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'TitleOfAssessmentDescriptor', @level2type=N'COLUMN', @level2name=N'TitleOfAssessmentDescriptorId'
GO

-- Extended Properties [tx].[ToolOrAssessmentUsedDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor ToolOrAssessmentUsed identifies the tool or assessment used to assess the student''s language acquisition. (C320)', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ToolOrAssessmentUsedDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'ToolOrAssessmentUsedDescriptor', @level2type=N'COLUMN', @level2name=N'ToolOrAssessmentUsedDescriptorId'
GO

-- Extended Properties [tx].[TruancyDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor Truancy is populated from Code Table C346.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'TruancyDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'TruancyDescriptor', @level2type=N'COLUMN', @level2name=N'TruancyDescriptorId'
GO

-- Extended Properties [tx].[UnaccompaniedYouthDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor UnaccompaniedYouth is populated from Code Table C192.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'UnaccompaniedYouthDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'UnaccompaniedYouthDescriptor', @level2type=N'COLUMN', @level2name=N'UnaccompaniedYouthDescriptorId'
GO

-- Extended Properties [tx].[UnschooledAsyleeRefugeeDescriptor] --
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Descriptor UnschooledAsyleeRefugee is populated from Code Table C183.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'UnschooledAsyleeRefugeeDescriptor'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique identifier used as Primary Key, not derived from business logic, when acting as Foreign Key, references the parent table.', @level0type=N'SCHEMA', @level0name=N'tx', @level1type=N'TABLE', @level1name=N'UnschooledAsyleeRefugeeDescriptor', @level2type=N'COLUMN', @level2name=N'UnschooledAsyleeRefugeeDescriptorId'
GO

